/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ScopedDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;

public final class VariantDefinition
extends ScopedDefinition {
    private final Definition fDefinition;
    private final String fCurrentField;
    private final String fFieldName;
    private final SimpleDatatypeDefinition fTagDef;

    public VariantDefinition(@NonNull VariantDeclaration declaration, IDefinitionScope definitionScope, SimpleDatatypeDefinition tagDef, String selectedField, @NonNull String fieldName, Definition fieldValue) {
        super(declaration, definitionScope, fieldName);
        this.fTagDef = tagDef;
        this.fFieldName = fieldName;
        this.fCurrentField = selectedField;
        this.fDefinition = fieldValue;
    }

    public VariantDefinition(@NonNull VariantDeclaration declaration, IDefinitionScope definitionScope, EnumDefinition tagDef, String selectedField, @NonNull String fieldName, Definition fieldValue) {
        super(declaration, definitionScope, fieldName);
        this.fTagDef = tagDef;
        this.fFieldName = fieldName;
        this.fCurrentField = selectedField;
        this.fDefinition = fieldValue;
    }

    @Override
    public VariantDeclaration getDeclaration() {
        return (VariantDeclaration)super.getDeclaration();
    }

    public String getCurrentFieldName() {
        return this.fCurrentField;
    }

    public Definition getCurrentField() {
        return this.fDefinition;
    }

    @Override
    public long size() {
        return this.fDefinition.size() + this.fTagDef.size();
    }

    @Override
    public IDefinition lookupDefinition(String lookupPath) {
        IDefinition def;
        if (lookupPath == null) {
            return null;
        }
        if (lookupPath.equals(this.fFieldName)) {
            return this.fDefinition;
        }
        if (lookupPath.equals(this.fTagDef.getDeclaration().getRole())) {
            return this.fTagDef;
        }
        if (lookupPath.equals(this.fDefinition.getDeclaration().getRole())) {
            return this.fDefinition;
        }
        if (this.fDefinition instanceof ScopedDefinition && (def = ((ScopedDefinition)this.fDefinition).lookupDefinition(lookupPath, this)) != null) {
            return def;
        }
        IDefinitionScope definitionScope = this.getDefinitionScope();
        if (definitionScope instanceof StructDefinition) {
            StructDefinition structDefinition = (StructDefinition)definitionScope;
            return structDefinition.lookupDefinition(lookupPath, this);
        }
        return definitionScope.lookupDefinition(lookupPath);
    }

    @Override
    public IDefinition lookupDefinition(String lookupPath, ScopedDefinition definitionToExclude) {
        IDefinition def;
        if (lookupPath == null) {
            return null;
        }
        if (lookupPath.equals(this.fFieldName)) {
            return this.fDefinition;
        }
        if (lookupPath.equals(this.fTagDef.getDeclaration().getRole())) {
            return this.fTagDef;
        }
        if (lookupPath.equals(this.fDefinition.getDeclaration().getRole())) {
            return this.fDefinition;
        }
        if (this.fDefinition instanceof ScopedDefinition && (def = ((ScopedDefinition)this.fDefinition).lookupDefinition(lookupPath, definitionToExclude)) != null) {
            return def;
        }
        IDefinitionScope definitionScope = this.getDefinitionScope();
        if (definitionScope instanceof StructDefinition) {
            StructDefinition structDefinition = (StructDefinition)definitionScope;
            return structDefinition.lookupDefinition(lookupPath, this);
        }
        return definitionScope.lookupDefinition(lookupPath);
    }

    @Override
    public String toString() {
        return "{ " + this.getCurrentFieldName() + " = " + String.valueOf(this.getCurrentField()) + " }";
    }
}

