/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.quickoutline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.wst.sse.ui.quickoutline.StringMatcher;

public class StringPatternFilter
extends ViewerFilter {
    protected StringMatcher fStringMatcher;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        StringMatcher matcher = this.fStringMatcher;
        if (matcher == null || !(viewer instanceof TreeViewer)) {
            return true;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        String matchName = this.getMatchLabel(element, treeViewer);
        if ((matchName = TextProcessor.deprocess((String)matchName)) != null && matcher.match(matchName)) {
            return true;
        }
        return this.hasUnfilteredChild(treeViewer, element);
    }

    protected String getMatchLabel(Object element, TreeViewer treeViewer) {
        return ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
    }

    private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (this.select((Viewer)viewer, element, children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updatePattern(String pattern) {
        this.fStringMatcher = pattern.length() == 0 ? null : new StringMatcher(pattern, pattern.toLowerCase().equals(pattern), false);
    }

    public StringMatcher getStringMatcher() {
        return this.fStringMatcher;
    }
}

