/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IFileNomination;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public abstract class InternalFileContentProvider
extends IncludeFileContentProvider {
    private IIncludeFileResolutionHeuristics fIncludeResolutionHeuristics;
    private final Map<String, IFileNomination> fPragmaOnce = new HashMap<String, IFileNomination>();
    private final Map<String, List<ISignificantMacros>> fLoadedVersions = new HashMap<String, List<ISignificantMacros>>();

    public boolean getInclusionExists(String path) {
        if (UNCPathConverter.isUNC(path)) {
            try {
                IFileStore store = EFS.getStore((URI)UNCPathConverter.getInstance().toURI(path));
                return store.fetchInfo().exists();
            }
            catch (CoreException e) {
                return false;
            }
        }
        return new File(path).exists();
    }

    public abstract InternalFileContent getContentForInclusion(String var1, IMacroDictionary var2);

    public abstract InternalFileContent getContentForInclusion(IIndexFileLocation var1, String var2);

    public InternalFileContent getContentForContextToHeaderGap(String filePath, IMacroDictionary macroDictionary) throws DependsOnOutdatedFileException {
        return null;
    }

    public void resetForTranslationUnit() {
        this.fPragmaOnce.clear();
        this.fLoadedVersions.clear();
    }

    public void reportPragmaOnceSemantics(String file, IFileNomination nomination) {
        this.fPragmaOnce.put(file, nomination);
    }

    public IFileNomination isIncludedWithPragmaOnceSemantics(String filePath) {
        return this.fPragmaOnce.get(filePath);
    }

    public final IIncludeFileResolutionHeuristics getIncludeHeuristics() {
        return this.fIncludeResolutionHeuristics;
    }

    public final void setIncludeResolutionHeuristics(IIncludeFileResolutionHeuristics heuristics) {
        this.fIncludeResolutionHeuristics = heuristics;
    }

    public List<ISignificantMacros> getLoadedVersions(String path) {
        List<ISignificantMacros> result = this.fLoadedVersions.get(path);
        return result == null ? Collections.emptyList() : result;
    }

    public void addLoadedVersions(String path, int reduceVersions, ISignificantMacros sig) {
        List<ISignificantMacros> list = this.fLoadedVersions.get(path);
        if (list == null || reduceVersions == 0) {
            this.fLoadedVersions.put(path, Collections.singletonList(sig));
        } else if (!list.contains(sig)) {
            if (list.size() == 1) {
                ISignificantMacros first = list.get(0);
                list = new ArrayList<ISignificantMacros>(2);
                list.add(first);
                this.fLoadedVersions.put(path, list);
            } else if (reduceVersions > 0 && reduceVersions < list.size()) {
                list.subList(reduceVersions, list.size()).clear();
            }
            list.add(sig);
        }
    }

    public String getContextPath() {
        return null;
    }

    public boolean shouldIndexAllHeaderVersions(String headerFileName) {
        return false;
    }

    public static final class DependsOnOutdatedFileException
    extends Exception {
        public final Object fTu;
        public final IIndexFragmentFile fIndexFile;

        public DependsOnOutdatedFileException(Object tu, IIndexFragmentFile file) {
            this.fTu = tu;
            this.fIndexFile = file;
        }
    }
}

