/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.cpp.CompositeCPPBinding;
import org.eclipse.cdt.internal.core.index.composite.cpp.CompositeCPPNamespaceScope;

class CompositeCPPNamespace
extends CompositeCPPBinding
implements ICPPNamespace {
    ICPPNamespace[] namespaces;

    public CompositeCPPNamespace(ICompositesFactory cf, ICPPNamespace[] namespaces) {
        super(cf, namespaces[0]);
        this.namespaces = namespaces;
    }

    @Override
    public IBinding[] getMemberBindings() {
        IIndexFragmentBinding[][] memberBindings = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            IBinding[] bindings = this.namespaces[i].getMemberBindings();
            memberBindings[i] = new IIndexFragmentBinding[bindings.length];
            System.arraycopy(bindings, 0, memberBindings[i], 0, bindings.length);
            ++i;
        }
        return this.cf.getCompositeBindings(memberBindings);
    }

    @Override
    public ICPPNamespaceScope getNamespaceScope() {
        return new CompositeCPPNamespaceScope(this.cf, this.namespaces);
    }

    @Override
    public boolean isInline() {
        ICPPNamespace[] iCPPNamespaceArray = this.namespaces;
        int n = this.namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPNamespace namespace = iCPPNamespaceArray[n2];
            if (namespace.isInline()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

