/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectLeveledImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipLeveledStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarLeveledStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ZipLeveledStructureProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ArchiveUtil {
    private static final int THRESHOLD_ENTRIES = 5000;
    static final int THRESHOLD_SIZE = 1000000000;
    private static final double THRESHOLD_RATIO = 100.0;

    private ArchiveUtil() {
    }

    public static boolean isArchiveFile(File sourceFile) {
        String absolutePath = sourceFile.getAbsolutePath();
        return ArchiveUtil.isTarFile(absolutePath) || ArchiveUtil.isZipFile(absolutePath) || ArchiveUtil.isGzipFile(absolutePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isZipFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipFile specifiedZipSourceFile = ArchiveUtil.getSpecifiedZipSourceFile(fileName);){
                if (specifiedZipSourceFile == null) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isTarFile(String fileName) {
        TarFile specifiedTarSourceFile = ArchiveUtil.getSpecifiedTarSourceFile(fileName);
        if (specifiedTarSourceFile != null) {
            try {
                specifiedTarSourceFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGzipFile(String fileName) {
        if (fileName.isEmpty()) return false;
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                GzipFile specifiedTarSourceFile = new GzipFile(fileName);
                if (specifiedTarSourceFile == null) return true;
                specifiedTarSourceFile.close();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        File file = new File(fileName);
        if (file.isDirectory()) {
            return null;
        }
        try {
            return new ZipFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        File tarCandidate = new File(fileName);
        if (tarCandidate.length() < 512L) {
            return null;
        }
        try {
            return new TarFile(tarCandidate);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static boolean ensureZipSourceIsValid(String archivePath) {
        ZipFile specifiedFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveUtil.closeZipFile(specifiedFile);
    }

    static boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static boolean ensureTarSourceIsValid(String archivePath) {
        TarFile specifiedFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveUtil.closeTarFile(specifiedFile);
    }

    static boolean ensureGzipSourceIsValid(String archivePath) {
        return ArchiveUtil.isGzipFile(archivePath);
    }

    static boolean closeTarFile(TarFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static long getArchiveSize(String archivePath) {
        TarFile tarFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
        long archiveSize = 0L;
        if (tarFile != null) {
            ArrayList<TarArchiveEntry> entries = Collections.list(tarFile.entries());
            for (TarArchiveEntry tarArchiveEntry : entries) {
                archiveSize += tarArchiveEntry.getSize();
            }
            ArchiveUtil.closeTarFile(tarFile);
            return archiveSize;
        }
        ZipFile zipFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            long archiveEntries = 0L;
            long entrySize = 0L;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                entrySize = ArchiveUtil.getZipEntrySize(zipFile, entry);
                if (entrySize == -1L) {
                    ArchiveUtil.closeZipFile(zipFile);
                    return -1L;
                }
                archiveSize += entrySize;
                ++archiveEntries;
            }
            ArchiveUtil.closeZipFile(zipFile);
            if (ArchiveUtil.verifyZipFileIsSafe(archiveSize, archiveEntries)) {
                return archiveSize;
            }
        }
        if (zipFile == null) {
            return 0L;
        }
        return -1L;
    }

    public static long getZipEntrySize(ZipFile zipFile, ZipEntry entry) {
        long entrySize = 0L;
        try {
            BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(entry));
            int numBytes = -1;
            byte[] inputBuffer = new byte[2048];
            while ((numBytes = ((InputStream)in).read(inputBuffer)) > 0) {
                entrySize += (long)numBytes;
            }
        }
        catch (IOException e) {
            return -1L;
        }
        if (ArchiveUtil.verifyEntryIsSafe(entrySize, entry.getCompressedSize())) {
            return entrySize;
        }
        return -1L;
    }

    private static boolean verifyEntryIsSafe(long entrySize, long compressedSize) {
        String unsafeZipEntriesMessage = ". File seems unsafe to open.";
        if (compressedSize < 0L) {
            Activator activator = new Activator();
            activator.logError("Zip file has invalid compression size: " + compressedSize + unsafeZipEntriesMessage);
            return false;
        }
        if (compressedSize == 0L) {
            return true;
        }
        double compressionRatio = entrySize / compressedSize;
        if (compressionRatio > 100.0) {
            Activator activator = new Activator();
            activator.logError("Zip file has entries with too high a compression ratio: " + compressionRatio + unsafeZipEntriesMessage);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static boolean verifyZipFileIsSafe(long archiveSize, long archiveEntries) {
        String unsafeZipEntriesMessage = ". File seems unsafe to open.";
        String unsafeZipSizeMessage = " bytes. File seems unsafe to open.";
        if (archiveEntries > 5000L) {
            Activator activator = new Activator();
            activator.logError("Zip file has too many entries: " + archiveEntries + unsafeZipEntriesMessage);
            return false;
        }
        if (archiveSize > 1000000000L) {
            Activator activator = new Activator();
            activator.logError("Zip file is too large: " + archiveSize + unsafeZipSizeMessage);
            return false;
        }
        return true;
    }

    public static Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> getRootObjectAndProvider(File sourceFile, Shell shell) {
        if (sourceFile == null) {
            return null;
        }
        IFileSystemObject rootElement = null;
        FileSystemObjectImportStructureProvider importStructureProvider = null;
        if (!ArchiveUtil.isArchiveFile(sourceFile)) {
            importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            rootElement = importStructureProvider.getIFileSystemObject(sourceFile);
        } else {
            FileSystemObjectLeveledImportStructureProvider leveledImportStructureProvider = null;
            String archivePath = sourceFile.getAbsolutePath();
            if (ArchiveUtil.isTarFile(archivePath)) {
                if (ArchiveUtil.ensureTarSourceIsValid(archivePath)) {
                    TarFile tarFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new TarLeveledStructureProvider(tarFile), archivePath);
                }
            } else if (ArchiveUtil.ensureZipSourceIsValid(archivePath)) {
                ZipFile zipFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
                leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new ZipLeveledStructureProvider(zipFile), archivePath);
            } else if (ArchiveUtil.ensureGzipSourceIsValid(archivePath)) {
                GzipFile zipFile = null;
                try {
                    zipFile = new GzipFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new GzipLeveledStructureProvider(zipFile), archivePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (leveledImportStructureProvider == null) {
                return null;
            }
            rootElement = leveledImportStructureProvider.getRoot();
            importStructureProvider = leveledImportStructureProvider;
        }
        if (rootElement == null) {
            return null;
        }
        return new Pair((Object)rootElement, (Object)importStructureProvider);
    }

    public static IPath toValidNamesPath(String path) {
        Path newSafePath;
        Object newFullPath = newSafePath = TmfTraceCoreUtils.newSafePath((String)path);
        String[] segments = newSafePath.segments();
        int i = 0;
        while (i < segments.length) {
            String segment = TmfTraceCoreUtils.validateName((String)TmfTraceCoreUtils.safePathToString((String)segments[i]));
            newFullPath = i == 0 ? new Path(segment) : newFullPath.append(segment);
            ++i;
        }
        return newFullPath;
    }
}

