/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class DSAElGamalKeyRingGenerator {
    private static final int SIG_HASH = 10;
    private static final int[] HASH_PREFERENCES = new int[]{10, 9, 8, 11};
    private static final int[] SYM_PREFERENCES = new int[]{9, 8, 7};
    private static final int[] COMP = new int[]{2, 3, 2, 0};

    private static void exportKeyPair(OutputStream outputStream, OutputStream outputStream2, KeyPair keyPair, KeyPair keyPair2, String string, char[] cArray, boolean bl) throws IOException, PGPException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(17, keyPair, new Date());
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(16, keyPair2, new Date());
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(jcaPGPKeyPair.getPublicKey().getAlgorithm(), 10);
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).setProvider("BC").build(cArray);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = DSAElGamalKeyRingGenerator.getPrimaryKeyHashedSubpackets();
        pGPSignatureSubpacketGenerator.setIssuerFingerprint(false, jcaPGPKeyPair.getPublicKey());
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketGenerator.generate(), null, jcaPGPContentSignerBuilder, pBESecretKeyEncryptor);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = DSAElGamalKeyRingGenerator.getEncryptionKeyHashedSubpackets();
        pGPSignatureSubpacketGenerator2.setIssuerFingerprint(false, jcaPGPKeyPair.getPublicKey());
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2, pGPSignatureSubpacketGenerator2.generate(), null);
        pGPKeyRingGenerator.generateSecretKeyRing().encode(outputStream);
        outputStream.close();
        if (bl) {
            outputStream2 = new ArmoredOutputStream(outputStream2);
        }
        pGPKeyRingGenerator.generatePublicKeyRing().encode(outputStream2);
        outputStream2.close();
    }

    private static PGPSignatureSubpacketGenerator getEncryptionKeyHashedSubpackets() {
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 12);
        return pGPSignatureSubpacketGenerator;
    }

    private static PGPSignatureSubpacketGenerator getPrimaryKeyHashedSubpackets() {
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(false, HASH_PREFERENCES);
        pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, SYM_PREFERENCES);
        pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, COMP);
        pGPSignatureSubpacketGenerator.setFeature(false, (byte)1);
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 3);
        return pGPSignatureSubpacketGenerator;
    }

    private static KeyPair generateElGamalKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ELGAMAL", "BC");
        BigInteger bigInteger = new BigInteger("2", 16);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger2, bigInteger);
        keyPairGenerator.initialize(dHParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static KeyPair generateDSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        keyPairGenerator.initialize(3072);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray.length < 2) {
            System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        KeyPair keyPair = DSAElGamalKeyRingGenerator.generateDSAKeyPair();
        KeyPair keyPair2 = DSAElGamalKeyRingGenerator.generateElGamalKeyPair();
        if (stringArray[0].equals("-a")) {
            if (stringArray.length < 3) {
                System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream fileOutputStream = new FileOutputStream("secret.asc");
            FileOutputStream fileOutputStream2 = new FileOutputStream("pub.asc");
            DSAElGamalKeyRingGenerator.exportKeyPair(fileOutputStream, fileOutputStream2, keyPair, keyPair2, stringArray[1], stringArray[2].toCharArray(), true);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream("secret.bpg");
            FileOutputStream fileOutputStream3 = new FileOutputStream("pub.bpg");
            DSAElGamalKeyRingGenerator.exportKeyPair(fileOutputStream, fileOutputStream3, keyPair, keyPair2, stringArray[0], stringArray[1].toCharArray(), false);
        }
    }
}

