/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionContainer;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionProxy;

class StructuredDocumentRegionUtil {
    static String getAttrValue(IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (region == null) {
            return null;
        }
        if (flatNode == null) {
            return null;
        }
        String value = flatNode.getText(region);
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar == '\"' || firstChar == '\'') {
            if (length == 1) {
                return "";
            }
            if (value.charAt(length - 1) == firstChar) {
                --length;
            }
            return value.substring(1, length);
        }
        return value;
    }

    static String getEntityRefName(IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (region == null) {
            return null;
        }
        String ref = flatNode.getText(region);
        int length = ref.length();
        if (length == 0) {
            return ref;
        }
        int offset = 0;
        if (ref.charAt(0) == '&') {
            offset = 1;
        }
        if (ref.charAt(length - 1) == ';') {
            --length;
        }
        if (offset >= length) {
            return null;
        }
        return ref.substring(offset, length);
    }

    static ITextRegion getFirstRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        if (flatNode == null) {
            return null;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return null;
        }
        return regions.get(0);
    }

    static String getFirstRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        if (flatNode == null) {
            return "UNDEFINED";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "UNDEFINED";
        }
        ITextRegion region = regions.get(0);
        return region.getType();
    }

    static IStructuredDocumentRegion getFirstStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            flatNode = ((StructuredDocumentRegionContainer)flatNode).getFirstStructuredDocumentRegion();
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        return flatNode;
    }

    static ITextRegion getLastRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        if (flatNode == null) {
            return null;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return null;
        }
        return regions.get(regions.size() - 1);
    }

    static String getLastRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        if (flatNode == null) {
            return "UNDEFINED";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "UNDEFINED";
        }
        ITextRegion region = regions.get(regions.size() - 1);
        return region.getType();
    }

    static IStructuredDocumentRegion getLastStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            flatNode = ((StructuredDocumentRegionContainer)flatNode).getLastStructuredDocumentRegion();
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        return flatNode;
    }

    static IStructuredDocumentRegion getStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            flatNode = ((StructuredDocumentRegionProxy)flatNode).getStructuredDocumentRegion();
        }
        return flatNode;
    }

    StructuredDocumentRegionUtil() {
    }
}

