/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal;

import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategyExtension;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.xml.core.internal.formatter.DefaultXMLPartitionFormatter;

public class XMLFormattingStrategy
extends ContextBasedFormattingStrategy
implements IFormattingStrategyExtension {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private IRegion fRegion;
    private DefaultXMLPartitionFormatter formatter = new DefaultXMLPartitionFormatter();

    public void format() {
        block9: {
            super.format();
            IDocument document = (IDocument)this.fDocuments.removeFirst();
            TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
            if (document != null && partition != null && this.fRegion != null) {
                try {
                    IStructuredModel model;
                    if (!(document instanceof IStructuredDocument) || (model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document)) == null) break block9;
                    try {
                        TextEdit edit = this.formatter.format(model, this.fRegion.getOffset(), this.fRegion.getLength());
                        if (edit == null) break block9;
                        try {
                            model.aboutToChangeModel();
                            edit.apply(document);
                        }
                        finally {
                            model.changedModel();
                        }
                    }
                    finally {
                        model.releaseFromEdit();
                    }
                }
                catch (BadLocationException e) {
                    Logger.log((int)1, (String)e.getMessage());
                }
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
        this.fRegion = (IRegion)context.getProperty((Object)"formatting.context.region");
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

