/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.Highlighter;

public class MarkerHighlighter
extends Highlighter {
    private final IFile fFile;
    private final Map<Match, IMarker> fMatchesToAnnotations;
    private final Object addHighlightsJobFamily;
    private volatile boolean fDisposed;
    private WorkspaceJob fRemoveAllJob;
    private WorkspaceJob fContentReplacedJob;

    public MarkerHighlighter(IFile file) {
        this.fFile = file;
        this.fMatchesToAnnotations = new HashMap<Match, IMarker>();
        this.fDisposed = false;
        this.addHighlightsJobFamily = new Object();
    }

    @Override
    public void addHighlights(final Match[] matches) {
        MarkerHighlighterWorkspaceJob addHighlightsJob = new MarkerHighlighterWorkspaceJob("Adding highlights", this.fFile){

            @Override
            void runOperation(IProgressMonitor monitor) {
                MarkerHighlighter.this.addHighlightsInternal(matches, monitor);
            }

            @Override
            public boolean belongsTo(Object family) {
                return family == MarkerHighlighter.this.addHighlightsJobFamily || super.belongsTo(family);
            }
        };
        addHighlightsJob.schedule();
    }

    private void addHighlightsInternal(Match[] matches, IProgressMonitor monitor) {
        try {
            SearchPlugin.getWorkspace().run(submonitor -> {
                if (this.fDisposed) {
                    return;
                }
                Match[] matchArray2 = matches;
                int n = matches.length;
                int n2 = 0;
                while (n2 < n) {
                    Match match = matchArray2[n2];
                    if (monitor.isCanceled() || submonitor.isCanceled()) {
                        return;
                    }
                    IMarker marker = this.createMarker(match);
                    if (marker != null) {
                        this.fMatchesToAnnotations.put(match, marker);
                    }
                    ++n2;
                }
            }, (ISchedulingRule)this.fFile, 1, null);
        }
        catch (CoreException e) {
            SearchPlugin.log(e.getStatus());
        }
    }

    private IMarker createMarker(Match match) throws CoreException {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        if (position == null) {
            if (match.getOffset() < 0 || match.getLength() < 0) {
                return null;
            }
            position = new Position(match.getOffset(), match.getLength());
        } else {
            position = new Position(position.getOffset(), position.getLength());
        }
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
        if (match.getBaseUnit() == 2) {
            attributes.put("charStart", position.getOffset());
            attributes.put("charEnd", position.getOffset() + position.getLength());
        } else {
            attributes.put("lineNumber", position.getOffset());
        }
        IMarker marker = match.isFiltered() ? this.fFile.createMarker("org.eclipse.search.filteredsearchmarker", attributes) : this.fFile.createMarker("org.eclipse.search.searchmarker", attributes);
        return marker;
    }

    @Override
    public void removeHighlights(final Match[] matches) {
        MarkerHighlighterWorkspaceJob removeHighlightsJob = new MarkerHighlighterWorkspaceJob("Removing highlights", this.fFile){

            @Override
            void runOperation(IProgressMonitor monitor) {
                MarkerHighlighter.this.removeHighlightsInternal(matches);
            }
        };
        removeHighlightsJob.schedule();
    }

    private void removeHighlightsInternal(Match[] matches) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            IMarker marker = this.fMatchesToAnnotations.remove(match);
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    SearchPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    @Override
    public void removeAll() {
        this.cancelAddingHighlights();
        if (this.fRemoveAllJob == null) {
            this.fRemoveAllJob = new MarkerHighlighterWorkspaceJob("Removing all search highlights", this.fFile){

                @Override
                void runOperation(IProgressMonitor monitor) {
                    MarkerHighlighter.this.removeAllInternal();
                }
            };
        }
        this.fRemoveAllJob.cancel();
        this.fRemoveAllJob.schedule();
    }

    private void removeAllInternal() {
        try {
            this.fFile.deleteMarkers("org.eclipse.search.searchmarker", true, 2);
            this.fFile.deleteMarkers("org.eclipse.search.filteredsearchmarker", true, 2);
            this.fMatchesToAnnotations.clear();
        }
        catch (CoreException e) {
            SearchPlugin.log(e.getStatus());
        }
    }

    @Override
    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!buffer.getLocation().equals((Object)this.fFile.getFullPath())) {
            return;
        }
        if (this.fContentReplacedJob == null) {
            this.fContentReplacedJob = new MarkerHighlighterWorkspaceJob("Updating search highlights", this.fFile){

                @Override
                void runOperation(IProgressMonitor monitor) {
                    MarkerHighlighter.this.handleContentReplacedInternal(monitor);
                }
            };
        }
        this.fContentReplacedJob.cancel();
        this.fContentReplacedJob.schedule();
    }

    private void handleContentReplacedInternal(IProgressMonitor monitor) {
        if (this.fDisposed) {
            return;
        }
        Match[] matches = new Match[this.fMatchesToAnnotations.size()];
        this.fMatchesToAnnotations.keySet().toArray(matches);
        this.removeAllInternal();
        this.addHighlightsInternal(matches, monitor);
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
        this.cancelAddingHighlights();
        super.dispose();
    }

    private void cancelAddingHighlights() {
        if (this.fContentReplacedJob != null) {
            this.fContentReplacedJob.cancel();
        }
        Job.getJobManager().cancel(this.addHighlightsJobFamily);
    }

    static abstract class MarkerHighlighterWorkspaceJob
    extends WorkspaceJob {
        public MarkerHighlighterWorkspaceJob(String jobName, IFile file) {
            super(jobName);
            this.setRule((ISchedulingRule)file);
            this.setSystem(true);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.runOperation(monitor);
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == MarkerHighlighter.class;
        }

        abstract void runOperation(IProgressMonitor var1) throws CoreException;
    }
}

