/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.SimpleBuffer;
import org.python.core.buffer.Strided1DWritableBuffer;
import org.python.core.buffer.ZeroByteBuffer;

public class SimpleWritableBuffer
extends SimpleBuffer {
    public SimpleWritableBuffer(int flags, byte[] storage, int index0, int size) throws PyException, NullPointerException {
        super(storage, index0, size);
        this.addFeatureFlags(1);
        this.checkRequestFlags(flags);
    }

    public SimpleWritableBuffer(int flags, byte[] storage) throws PyException, NullPointerException {
        super(storage);
        this.addFeatureFlags(1);
        this.checkRequestFlags(flags);
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public void storeAt(byte value, int index) {
        this.storage[this.index0 + index] = value;
    }

    @Override
    public void storeAt(byte value, int ... indices) {
        this.checkDimension(indices.length);
        this.storeAt(value, indices[0]);
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int length) {
        System.arraycopy(src, srcPos, this.storage, this.index0 + destIndex, length);
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        if (src.getLen() != this.getLen()) {
            throw SimpleWritableBuffer.differentStructure();
        }
        src.copyTo(this.storage, this.index0);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length) {
        if (length > 0) {
            int compIndex0 = this.index0 + start;
            return new SimpleView(this.getRoot(), flags, this.storage, compIndex0, length);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        if (stride == 1 || length < 2) {
            return this.getBufferSlice(flags, start, length);
        }
        int compIndex0 = this.index0 + start;
        return new Strided1DWritableBuffer.SlicedView(this.getRoot(), flags, this.storage, compIndex0, length, stride);
    }

    static class SimpleView
    extends SimpleWritableBuffer {
        PyBuffer root;

        public SimpleView(PyBuffer root, int flags, byte[] storage, int index0, int size) {
            super(flags, storage, index0, size);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

