/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.util;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.util.TextUtil;

public class ASTNodes {
    private ASTNodes() {
    }

    public static int offset(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return -1;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getNodeOffset() : -1;
    }

    public static int endOffset(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return -1;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getNodeOffset() + nodeLocation.getNodeLength() : -1;
    }

    public static int getStartingLineNumber(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return 0;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getStartingLineNumber() : 0;
    }

    public static int getEndingLineNumber(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return 0;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getEndingLineNumber() : 0;
    }

    public static int skipToNextLineAfterNode(String text, IASTNode node) {
        return TextUtil.skipToNextLine(text, ASTNodes.endOffset(node));
    }

    public static String getPrecedingWhitespaceInLine(String text, IASTNode node) {
        int offset = ASTNodes.offset(node);
        if (offset >= 0) {
            int i = offset;
            while (--i >= 0) {
                char c = text.charAt(i);
                if (c == '\n' || !Character.isWhitespace(c)) break;
            }
            return text.substring(++i, offset);
        }
        return "";
    }
}

