/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.utils;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;

public class LEB128 {
    public static long readUnsignedLeb(BitBuffer in) throws CTFException {
        long result = 0L;
        long shift = 0L;
        byte current = 0;
        do {
            current = (byte)in.get(8, false);
            result |= (long)(current & 0x7F) << (int)shift;
        } while ((current & 0x80) != 0 && (shift += 7L) < 64L);
        return result;
    }

    public static long readUnsignedLeb(DataInput in) throws IOException {
        long result = 0L;
        long shift = 0L;
        byte current = 0;
        do {
            current = in.readByte();
            result |= (long)(current & 0x7F) << (int)shift;
        } while ((current & 0x80) != 0 && (shift += 7L) < 64L);
        return result;
    }

    public static long readSignedLeb(BitBuffer in) throws CTFException {
        byte current;
        long result = 0L;
        int shift = 0;
        do {
            current = (byte)in.get(8, false);
            result |= (long)(current & 0x7F) << shift;
        } while ((current & 0x80) != 0 && (shift += 7) < 64);
        if ((current & 0x40) != 0 && shift < 64) {
            result |= -1L << shift;
        }
        return result;
    }

    public static long readSignedLeb(DataInput in) throws IOException {
        byte current;
        long result = 0L;
        int shift = 0;
        do {
            current = in.readByte();
            result |= (long)(current & 0x7F) << shift;
        } while ((current & 0x80) != 0 && (shift += 7) < 64);
        if ((current & 0x40) != 0 && shift < 64) {
            result |= -1L << shift;
        }
        return result;
    }
}

