/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TcpEventKey;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TcpLttngEventMatching
implements ITmfMatchEventDefinition {
    private static final Map<IKernelAnalysisEventLayout, Set<String>> REQUIRED_EVENTS = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private static final Map<ITmfTrace, IKernelAnalysisEventLayout> TRACE_LAYOUTS = new WeakHashMap<ITmfTrace, IKernelAnalysisEventLayout>();

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof IKernelTrace)) {
            return false;
        }
        IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
        TRACE_LAYOUTS.put(trace, layout);
        Set events = REQUIRED_EVENTS.computeIfAbsent(layout, eventLayout -> {
            HashSet eventsSet = new HashSet();
            eventsSet.addAll(eventLayout.eventsNetworkSend());
            eventsSet.addAll(eventLayout.eventsNetworkReceive());
            return eventsSet;
        });
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        ITmfTraceWithPreDefinedEvents ktrace = (ITmfTraceWithPreDefinedEvents)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll(events);
        return !traceEvents.isEmpty();
    }

    public TmfEventMatching.Direction getDirection(ITmfEvent event) {
        IKernelAnalysisEventLayout layout = TRACE_LAYOUTS.get(event.getTrace());
        if (layout == null) {
            return null;
        }
        String evname = event.getName();
        if (layout.eventsNetworkReceive().contains(evname)) {
            return TmfEventMatching.Direction.EFFECT;
        }
        if (layout.eventsNetworkSend().contains(evname)) {
            return TmfEventMatching.Direction.CAUSE;
        }
        return null;
    }

    public IEventMatchingKey getEventKey(ITmfEvent event) {
        IKernelAnalysisEventLayout layout = TRACE_LAYOUTS.get(event.getTrace());
        if (layout == null) {
            return null;
        }
        TmfEventField content = (TmfEventField)event.getContent();
        Long sequence = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpSeq());
        Long ack = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpAckSeq());
        Long flags = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpFlags());
        if (sequence == null || ack == null || flags == null) {
            return null;
        }
        TcpEventKey key = new TcpEventKey(sequence.longValue(), ack.longValue(), flags.longValue());
        return key;
    }
}

