/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TcpEventKey;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TcpEventMatching
implements ITmfMatchEventDefinition {
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"inet_sock_local_in", (Object)"inet_sock_local_out");

    private static boolean canMatchPacket(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        return content.getFieldValue(Long.class, new String[]{"seq"}) != null && content.getFieldValue(Long.class, new String[]{"ack_seq"}) != null && content.getFieldValue(Long.class, new String[]{"flags"}) != null;
    }

    public TmfEventMatching.Direction getDirection(ITmfEvent event) {
        String evname = event.getName();
        if (!TcpEventMatching.canMatchPacket(event)) {
            return null;
        }
        if (evname.equals("inet_sock_local_in")) {
            return TmfEventMatching.Direction.EFFECT;
        }
        if (evname.equals("inet_sock_local_out")) {
            return TmfEventMatching.Direction.CAUSE;
        }
        return null;
    }

    public IEventMatchingKey getEventKey(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long sequence = (Long)content.getFieldValue(Long.class, new String[]{"seq"});
        Long ack = (Long)content.getFieldValue(Long.class, new String[]{"ack_seq"});
        Long flags = (Long)content.getFieldValue(Long.class, new String[]{"flags"});
        if (sequence == null || ack == null || flags == null) {
            throw new IllegalArgumentException("Event does not have expected fields");
        }
        TcpEventKey key = new TcpEventKey(sequence.longValue(), ack.longValue(), flags.longValue());
        return key;
    }

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        ITmfTraceWithPreDefinedEvents ktrace = (ITmfTraceWithPreDefinedEvents)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll((Collection<?>)REQUIRED_EVENTS);
        return !traceEvents.isEmpty();
    }
}

