/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.trace;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.Activator;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.OpenTracingAspects;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.OpenTracingEvent;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.OpenTracingField;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.trace.OpenTracingSortingJob;
import org.eclipse.tracecompass.internal.provisional.jsontrace.core.trace.JsonTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class OpenTracingTrace
extends JsonTrace {
    private final @NonNull Iterable<@NonNull ITmfEventAspect<?>> fEventAspects = Lists.newArrayList(OpenTracingAspects.getAspects());
    private final Map<String, String> fProcesses = new HashMap<String, String>();

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        this.fProperties.put("Type", "Open-Tracing");
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this);
        this.fFile = new File(dir + new File(path).getName());
        if (!this.fFile.exists()) {
            OpenTracingSortingJob sortJob = new OpenTracingSortingJob((ITmfTrace)this, path);
            sortJob.schedule();
            while (sortJob.getResult() == null) {
                try {
                    sortJob.join();
                }
                catch (InterruptedException e) {
                    throw new TmfTraceException(e.getMessage(), (Throwable)e);
                }
            }
            IStatus result = sortJob.getResult();
            if (!result.isOK()) {
                throw new TmfTraceException("Job failed " + result.getMessage());
            }
        }
        try {
            this.fFileInput = new BufferedRandomAccessFile(this.fFile, "r");
            OpenTracingTrace.goToCorrectStart(this.fFileInput);
            this.registerProcesses(path);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    public void registerProcesses(String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader fileReader = new FileReader(path);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JsonReader reader = new JsonReader((Reader)fileReader);){
                    Gson gson = new Gson();
                    JsonObject object = (JsonObject)gson.fromJson(reader, JsonObject.class);
                    JsonElement trace = object.get("data").getAsJsonArray().get(0);
                    JsonObject processes = trace.getAsJsonObject().get("processes").getAsJsonObject();
                    int i = 1;
                    while (i <= processes.size()) {
                        String processName = "p" + i;
                        this.fProcesses.put(processName, gson.toJson(processes.get(processName)));
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.opentracing.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.opentracing.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 0;
        try {
            if (!TmfTraceUtils.isText((File)file)) {
                return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.opentracing.core");
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.opentracing.core", "IOException validating file: " + path, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                OpenTracingTrace.goToCorrectStart((RandomAccessFile)rafile);
                int lineCount = 0;
                int matches = 0;
                String line = OpenTracingTrace.readNextEventString(() -> rafile.read());
                while (line != null && lineCount++ < 100) {
                    try {
                        OpenTracingField field = OpenTracingField.parseJson(line, null);
                        if (field != null) {
                            ++matches;
                        }
                    }
                    catch (RuntimeException e2) {
                        confidence = Integer.MIN_VALUE;
                    }
                    confidence = 100 * matches / lineCount;
                    line = OpenTracingTrace.readNextEventString(() -> rafile.read());
                }
                if (matches == 0) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.opentracing.core", "Most assuredly NOT a Open-Tracing trace");
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.opentracing.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.opentracing.core");
    }

    private static void goToCorrectStart(RandomAccessFile rafile) throws IOException {
        StringBuilder sb = new StringBuilder();
        int val = rafile.read();
        HashSet<Integer> skipList = new HashSet<Integer>();
        skipList.add(58);
        skipList.add(9);
        skipList.add(10);
        skipList.add(13);
        skipList.add(32);
        skipList.add(8);
        skipList.add(12);
        while (val != -1 && val != 58 && sb.length() < 46) {
            if (!skipList.contains(val)) {
                sb.append((char)val);
            }
            val = rafile.read();
        }
        if (sb.toString().startsWith("{\"data\"")) {
            int data = 0;
            int nbBracket = 0;
            while (nbBracket < 2 && data != -1) {
                data = rafile.read();
                while (data != 91 && data != -1) {
                    data = rafile.read();
                }
                ++nbBracket;
            }
        } else {
            rafile.seek(0L);
        }
    }

    public Iterable<@NonNull ITmfEventAspect<?>> getEventAspects() {
        return this.fEventAspects;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        block6: {
            @Nullable ITmfLocation location = context.getLocation();
            if (location instanceof TmfLongLocation) {
                OpenTracingField field;
                block7: {
                    String nextJson;
                    TmfLongLocation tmfLongLocation = (TmfLongLocation)location;
                    Long locationInfo = tmfLongLocation.getLocationInfo();
                    if (location.equals(NULL_LOCATION)) {
                        locationInfo = 0L;
                    }
                    if (!locationInfo.equals(this.fFileInput.getFilePointer())) {
                        this.fFileInput.seek(locationInfo);
                    }
                    if ((nextJson = OpenTracingTrace.readNextEventString(() -> this.fFileInput.read())) == null) break block6;
                    String process = this.fProcesses.get(OpenTracingField.getProcess(nextJson));
                    field = OpenTracingField.parseJson(nextJson, process);
                    if (field != null) break block7;
                    return null;
                }
                try {
                    return new OpenTracingEvent((ITmfTrace)this, context.getRank(), field);
                }
                catch (IOException e) {
                    Activator.getInstance().logError("Error parsing event", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected synchronized void updateAttributes(ITmfContext context, @NonNull ITmfEvent event) {
        ITmfTimestamp endTime;
        ITmfTimestamp timestamp = event.getTimestamp();
        Long duration = (Long)event.getContent().getFieldValue(Long.class, new String[]{"duration"});
        ITmfTimestamp iTmfTimestamp = endTime = duration != null ? TmfTimestamp.fromNanos((long)(timestamp.toNanos() + duration)) : timestamp;
        if (event instanceof ITmfLostEvent) {
            endTime = ((ITmfLostEvent)event).getTimeRange().getEndTime();
        }
        if (this.getStartTime().equals(TmfTimestamp.BIG_BANG) || this.getStartTime().compareTo(timestamp) > 0) {
            this.setStartTime(timestamp);
        }
        if (this.getEndTime().equals(TmfTimestamp.BIG_CRUNCH) || this.getEndTime().compareTo(endTime) < 0) {
            this.setEndTime(endTime);
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.getNbEvents() <= rank) {
                this.setNbEvents(rank + 1L);
            }
            if (this.getIndexer() != null) {
                this.getIndexer().updateIndex(context, timestamp);
            }
        }
    }
}

