/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;

public class FetchParametersUtils {
    private FetchParametersUtils() {
    }

    public static @Nullable TimeQueryFilter createTimeQuery(Map<String, Object> parameters) {
        List<Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(parameters);
        return timeRequested == null ? null : new TimeQueryFilter(timeRequested);
    }

    public static @Nullable SelectionTimeQueryFilter createSelectionTimeQuery(Map<String, Object> parameters) {
        List<Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(parameters);
        List<Long> selectedItems = DataProviderParameterUtils.extractSelectedItems(parameters);
        return timeRequested == null || selectedItems == null ? null : new SelectionTimeQueryFilter(timeRequested, selectedItems);
    }

    public static @Nullable SelectionTimeQueryFilter createSelectionTimeQueryWithSamples(Map<String, Object> parameters) {
        DataProviderParameterUtils.TimeRangeWithSamples timeRange = DataProviderParameterUtils.extractTimeRangeWithSamples(parameters);
        List<Long> selectedItems = DataProviderParameterUtils.extractSelectedItems(parameters);
        return timeRange == null || selectedItems == null ? null : new SelectionTimeQueryFilter(timeRange.start(), timeRange.end(), timeRange.nbSamples(), selectedItems);
    }

    public static @Nullable VirtualTableQueryFilter createVirtualTableQueryFilter(Map<String, Object> parameters) {
        List<Long> columnRequested = DataProviderParameterUtils.extractLongList(parameters, "requested_table_column_ids");
        if (columnRequested == null) {
            return null;
        }
        Object indexObject = parameters.get("requested_table_index");
        if (!(indexObject instanceof Long) && !(indexObject instanceof Integer)) {
            return null;
        }
        long index = indexObject instanceof Long ? ((Long)indexObject).longValue() : ((Integer)indexObject).longValue();
        Object countObject = parameters.get("requested_table_count");
        if (!(countObject instanceof Integer)) {
            return null;
        }
        return new VirtualTableQueryFilter(columnRequested, index, (Integer)countObject);
    }

    public static Map<String, Object> timeQueryToMap(TimeQueryFilter queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long[] timesRequested = queryFilter.getTimesRequested();
        ArrayList<Long> longList = new ArrayList<Long>();
        long[] lArray = timesRequested;
        int n = timesRequested.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            longList.add(time);
            ++n2;
        }
        map.put("requested_times", longList);
        return map;
    }

    public static Map<String, Object> selectionTimeQueryToMap(SelectionTimeQueryFilter queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long[] timesRequested = queryFilter.getTimesRequested();
        Object selectedItems = queryFilter.getSelectedItems();
        ArrayList<Long> longList = new ArrayList<Long>();
        long[] lArray = timesRequested;
        int n = timesRequested.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            longList.add(time);
            ++n2;
        }
        map.put("requested_times", longList);
        map.put("requested_items", selectedItems);
        return map;
    }

    public static Map<String, Object> virtualTableQueryToMap(VirtualTableQueryFilter queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Long> columnsId = queryFilter.getColumnsId();
        long index = queryFilter.getIndex();
        int count = queryFilter.getCount();
        map.put("requested_table_column_ids", columnsId);
        map.put("requested_table_index", index);
        map.put("requested_table_count", count);
        return map;
    }

    public static Map<String, Object> filteredTimeQueryToMap(FilterTimeQueryFilter queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long[] timesRequested = queryFilter.getTimesRequested();
        boolean filtered = queryFilter.isFiltered();
        ArrayList<Long> longList = new ArrayList<Long>();
        long[] lArray = timesRequested;
        int n = timesRequested.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            longList.add(time);
            ++n2;
        }
        map.put("requested_times", longList);
        map.put("isFiltered", filtered);
        return map;
    }
}

