/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.preferences;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.repository.IRepositoryFactory;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class PreferencesHelper {
    @Deprecated
    private PreferencesHelper() {
    }

    public static String getScriptStorageLocation() {
        String location = PreferencesHelper.getUserScriptStorageLocation();
        if (location != null) {
            return location;
        }
        return PreferencesHelper.getDefaultScriptStorageLocation();
    }

    public static String getUserScriptStorageLocation() {
        for (IScriptLocation location : PreferencesHelper.getLocations()) {
            if (!location.isDefault()) continue;
            return location.getLocation();
        }
        return null;
    }

    public static String getDefaultScriptStorageLocation() {
        return URIUtil.toURI((IPath)Activator.getDefault().getStateLocation().append("recordedScripts")).toASCIIString();
    }

    public static Collection<IScriptLocation> getLocations() {
        HashSet<IScriptLocation> locations = new HashSet<IScriptLocation>();
        IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui.scripts");
        try {
            rootNode.accept(node -> {
                if (rootNode.equals(node)) {
                    return true;
                }
                String location = node.get("location", "");
                if (!location.isEmpty()) {
                    locations.add(PreferencesHelper.getLocationForNode((Preferences)node));
                }
                return false;
            });
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return locations;
    }

    public static IScriptLocation getLocationForNode(Preferences node) {
        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
        try {
            entry.setLocation(node.get("location", ""));
            entry.setRecursive(node.getBoolean("recursive", true));
            entry.setDefault(node.getBoolean("default", false));
        }
        catch (IllegalStateException e) {
            entry.setLocation(node.name().replace('|', '/'));
        }
        return entry;
    }

    public static void addLocation(IScriptLocation entry) {
        String path = entry.getLocation().replace('/', '|');
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui.scripts/" + path);
        node.put("location", entry.getLocation());
        node.putBoolean("default", entry.isDefault());
        node.putBoolean("recursive", entry.isRecursive());
    }

    public static void removeLocation(String locationURI) {
        String path = locationURI.replace('/', '|');
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui.scripts/" + path);
        if (node != null) {
            try {
                node.removeNode();
            }
            catch (BackingStoreException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not remove storage location for \"" + locationURI + "\""), (Throwable)e);
            }
        }
    }
}

