/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class MigrationPage
extends WizardPage
implements ISelectableIUsPage,
Listener {
    protected String currentMessage;
    protected CheckboxTreeViewer viewer = null;
    protected Exception finishException;
    protected boolean entryChanged = false;
    protected static IProfileRegistry profileRegistry = null;
    static IProvisioningAgent agent = null;
    protected Button updateToLatest;
    public static final String REMIND_ME_LATER = "remindMeToMigrateLater";
    IProfile profile = null;
    private ProvisioningOperationWizard wizard;
    private ProvisioningUI ui;
    protected IProvisioningAgent otherInstanceAgent = null;
    private Collection<IInstallableUnit> unitsToMigrate;
    private Set<IInstallableUnit> selectedUnitsToMigrate;
    private IProfile toImportFrom = null;
    private URI[] metaURIs = null;
    private URI[] artiURIs = null;
    private Set checkedElements;
    private Set checkedElementsUpdates;
    private boolean getUpdatesCanceled;

    static {
        BundleContext context = Platform.getBundle((String)"org.eclipse.equinox.p2.ui").getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, IProvisioningAgent.class, null);
        tracker.open();
        agent = (IProvisioningAgent)tracker.getService();
        tracker.close();
        if (agent != null) {
            profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        }
    }

    public MigrationPage(String pageName) {
        super(pageName);
    }

    public MigrationPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, IProfile toImportFrom, Collection<IInstallableUnit> unitsToMigrate, boolean firstTime) {
        super("MigrationPageInstance");
        this.wizard = wizard;
        this.ui = ui;
        this.profile = this.getSelfProfile();
        this.toImportFrom = toImportFrom;
        this.unitsToMigrate = unitsToMigrate;
        this.setTitle(firstTime ? ProvUIMessages.MigrationPage_DIALOG_TITLE_FIRSTRUN : ProvUIMessages.MigrationPage_DIALOG_TITLE);
        this.setDescription(NLS.bind((String)ProvUIMessages.MigrationPage_DIALOG_DESCRIPTION, (Object)Platform.getProduct().getName()));
    }

    public MigrationPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, boolean firstTime) {
        super("importfrominstancepage");
        this.wizard = wizard;
        this.ui = ui;
        this.setTitle(firstTime ? ProvUIMessages.MigrationPage_DIALOG_TITLE_FIRSTRUN : ProvUIMessages.MigrationPage_DIALOG_TITLE);
        this.setDescription(NLS.bind((String)ProvUIMessages.MigrationPage_DIALOG_DESCRIPTION, (Object)Platform.getProduct().getName()));
    }

    protected IProfile getSelfProfile() {
        if (profileRegistry != null) {
            String selfID = System.getProperty("eclipse.p2.profile");
            if (selfID == null) {
                selfID = "_SELF_";
            }
            return profileRegistry.getProfile(selfID);
        }
        return null;
    }

    private void createColumns(TreeViewer treeViewer) {
        String[] titles = new String[]{ProvUIMessages.Column_Name, ProvUIMessages.Column_Version, ProvUIMessages.Column_Id};
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            if (titles[i].equals(ProvUIMessages.Column_Name)) {
                column.getColumn().setWidth(300);
                this.updateTableSorting(i);
            } else {
                column.getColumn().setWidth(200);
            }
            int columnIndex = i++;
            column.getColumn().addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTableSorting(columnIndex)));
        }
    }

    protected void updateTableSorting(int columnIndex) {
        TreeViewerComparator comparator = (TreeViewerComparator)this.viewer.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(columnIndex));
        this.viewer.getTree().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.viewer.refresh(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createContents(composite);
        if (!this.validateOptionsGroup()) {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected IUColumnConfig[] getColumnConfig() {
        return new IUColumnConfig[]{new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20), new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_IdColumnTitle, 0, 40)};
    }

    protected void createContents(Composite composite) {
        this.createInstallationTable(composite);
        this.createAdditionOptions(composite);
    }

    protected void createInstallationTable(final Composite parent) {
        SashForm sashForm = new SashForm(parent, 512);
        FillLayout fill = new FillLayout();
        sashForm.setLayout((Layout)fill);
        GridData data = new GridData(1808);
        sashForm.setLayoutData((Object)data);
        Composite sashComposite = new Composite((Composite)sashForm, 0);
        GridLayout grid = new GridLayout();
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        sashComposite.setLayout((Layout)grid);
        PatternFilter filter = this.getPatternFilter();
        filter.setIncludeLeadingWildcard(true);
        ImportExportFilteredTree filteredTree = new ImportExportFilteredTree(sashComposite, 68354, filter, true);
        this.viewer = (CheckboxTreeViewer)filteredTree.getViewer();
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        GridData treeDataGrid = new GridData(1808);
        treeDataGrid.heightHint = this.convertHeightInCharsToPixels(10);
        treeDataGrid.widthHint = this.convertWidthInCharsToPixels(80);
        tree.setLayoutData((Object)treeDataGrid);
        this.viewer.setComparator((ViewerComparator)new TreeViewerComparator());
        this.viewer.setComparer((IElementComparer)new ProvElementComparer());
        this.createColumns((TreeViewer)this.viewer);
        ITreeContentProvider contentProvider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addCheckStateListener(event -> {
            if (!event.getChecked() && importExportFilteredTree.checkState != null) {
                ArrayList<Object> toRemove = new ArrayList<Object>(1);
                if (contentProvider.hasChildren(event.getElement())) {
                    Object[] children;
                    HashSet<Object> unchecked = new HashSet<Object>();
                    Object[] objectArray = children = contentProvider.getChildren(event.getElement());
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        unchecked.add(child);
                        ++n2;
                    }
                    for (Object current : importExportFilteredTree.checkState) {
                        if (current == null || !unchecked.contains(current)) continue;
                        toRemove.add(current);
                    }
                } else {
                    for (Object element : importExportFilteredTree.checkState) {
                        if (!this.viewer.getComparer().equals(element, event.getElement())) continue;
                        toRemove.add(element);
                    }
                }
                importExportFilteredTree.checkState.removeAll(toRemove);
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){
            private final int[] columnRate = new int[]{4, 2, 2};

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point size = tree.computeSize(-1, -1);
                ScrollBar vBar = tree.getVerticalBar();
                int width = area.width - tree.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                TreeColumn[] columns = tree.getColumns();
                int hasUsed = 0;
                int i = 0;
                if (oldSize.x > area.width) {
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                    tree.setSize(area.width, area.height);
                } else {
                    tree.setSize(area.width, area.height);
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                }
            }
        });
        this.selectedUnitsToMigrate = this.identifyUnitsToBeMigrated();
        ICheckStateProvider provider = this.getViewerDefaultState();
        if (provider != null) {
            this.viewer.setCheckStateProvider(provider);
        } else {
            this.viewer.addSelectionChangedListener(event -> this.updatePageCompletion());
        }
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setInput(this.getInput());
        this.viewer.getTree().addListener(13, event -> {
            if (event.item instanceof TreeItem && event.detail == 32) {
                TreeItem treeItem = (TreeItem)event.item;
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)event.item.getData(), IInstallableUnit.class);
                if (treeItem.getChecked()) {
                    this.selectedUnitsToMigrate.add(iu);
                } else {
                    this.selectedUnitsToMigrate.remove(iu);
                }
            }
            this.updatePageCompletion();
        });
        Composite buttons = new Composite(sashComposite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        buttons.setLayout((Layout)new RowLayout(256));
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(ProvUIMessages.AbstractPage_ButtonSelectAll);
        selectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (!item.getChecked()) {
                    item.setChecked(true);
                    Event event = new Event();
                    event.widget = item.getParent();
                    event.detail = 32;
                    event.item = item;
                    event.type = 13;
                    this.viewer.getTree().notifyListeners(13, event);
                }
                ++n2;
            }
            this.updatePageCompletion();
        }));
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(ProvUIMessages.AbstractPage_ButtonDeselectAll);
        deselectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getChecked()) {
                    item.setChecked(false);
                    Event event = new Event();
                    event.widget = item.getParent();
                    event.detail = 32;
                    event.item = item;
                    event.type = 13;
                    this.viewer.getTree().notifyListeners(13, event);
                }
                this.viewer.setSubtreeChecked(item.getData(), false);
                ++n2;
            }
            this.updatePageCompletion();
        }));
    }

    private Set<IInstallableUnit> identifyUnitsToBeMigrated() {
        HashSet<IInstallableUnit> ius = new HashSet<IInstallableUnit>();
        if (this.profile != null) {
            for (IInstallableUnit iu : this.unitsToMigrate) {
                IQueryResult collector = this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), (IProgressMonitor)new NullProgressMonitor());
                if (!collector.isEmpty()) continue;
                ius.add(iu);
            }
        }
        return ius;
    }

    protected void createAdditionOptions(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateToLatest = new Button(composite, 32);
        this.updateToLatest.setText(ProvUIMessages.MigrationPage_UPDATE_TO_LATEST);
        this.updateToLatest.setSelection(MigrationPage.loadCustomizedSetting());
    }

    protected PatternFilter getPatternFilter() {
        return new AvailableIUPatternFilter(this.getColumnConfig());
    }

    protected ICheckStateProvider getViewerDefaultState() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
                return MigrationPage.this.selectedUnitsToMigrate.contains(iu);
            }
        };
    }

    protected ITreeContentProvider getContentProvider() {
        ProvElementContentProvider provider = new ProvElementContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof InstalledIUElement) {
                    return false;
                }
                return super.hasChildren(element);
            }

            public Object[] getChildren(Object parent) {
                if (parent instanceof InstalledIUElement) {
                    return new Object[0];
                }
                return super.getChildren(parent);
            }
        };
        return provider;
    }

    protected boolean determinePageCompletion() {
        this.currentMessage = null;
        boolean complete = this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected int getBrowseDialogStyle() {
        return 4096;
    }

    public void handleEvent(Event event) {
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    protected boolean validateOptionsGroup() {
        if (this.viewer == null || this.viewer.getCheckedElements().length > 0) {
            return true;
        }
        this.currentMessage = this.getNoOptionsMessage();
        return false;
    }

    protected ProvisioningOperationWizard getProvisioningWizard() {
        return this.wizard;
    }

    protected ProvisioningUI getProvisioningUI() {
        return this.ui;
    }

    public boolean hasInstalled(IInstallableUnit iu) {
        IQueryResult results = this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), null);
        return !results.isEmpty();
    }

    public String getIUNameWithDetail(IInstallableUnit iu) {
        IQueryResult results = this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), null);
        String text = iu.getProperty("org.eclipse.equinox.p2.name", null);
        String string = text = text != null ? text : iu.getId();
        if (!results.isEmpty()) {
            boolean hasHigherVersion = false;
            boolean hasEqualVersion = false;
            for (IInstallableUnit installedIU : results.toSet()) {
                int compareValue = installedIU.getVersion().compareTo((Object)iu.getVersion());
                if (compareValue > 0) {
                    hasHigherVersion = true;
                    break;
                }
                if (compareValue != 0) continue;
                hasEqualVersion = true;
            }
            if (hasHigherVersion) {
                return NLS.bind((String)ProvUIMessages.AbstractImportPage_HigherVersionInstalled, (Object)text);
            }
            if (hasEqualVersion) {
                return NLS.bind((String)ProvUIMessages.AbstractImportPage_SameVersionInstalled, (Object)text);
            }
        }
        return text;
    }

    protected void doFinish() throws Exception {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    protected String getDialogTitle() {
        return ProvUIMessages.MigrationPage_DIALOG_TITLE;
    }

    protected Object getInput() {
        IUElementListRoot root = new IUElementListRoot(this.ui);
        ArrayList<AvailableIUElement> elements = new ArrayList<AvailableIUElement>(this.unitsToMigrate.size());
        for (IInstallableUnit unit : this.unitsToMigrate) {
            elements.add(new AvailableIUElement((Object)root, unit, this.toImportFrom.getProfileId(), false));
        }
        root.setChildren(elements.toArray());
        return root;
    }

    protected String getInvalidDestinationMessage() {
        return "";
    }

    protected String getNoOptionsMessage() {
        return ProvUIMessages.MigrationPage_SELECT_COMPONENT;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ImportFromInstallationLabelProvider();
    }

    public void dispose() {
        super.dispose();
        if (this.otherInstanceAgent != null) {
            this.otherInstanceAgent.stop();
            this.otherInstanceAgent = null;
            this.toImportFrom = null;
        }
        this.cleanLocalRepository();
    }

    public void cleanLocalRepository() {
        if (this.metaURIs != null && this.metaURIs.length > 0) {
            IProvisioningAgent runningAgent = this.getProvisioningUI().getSession().getProvisioningAgent();
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)runningAgent.getService(IMetadataRepositoryManager.class);
            URI[] uRIArray = this.metaURIs;
            int n = this.metaURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                manager.removeRepository(uri);
                ++n2;
            }
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)runningAgent.getService(IArtifactRepositoryManager.class);
            URI[] uRIArray2 = this.artiURIs;
            int n3 = this.artiURIs.length;
            n = 0;
            while (n < n3) {
                URI uri = uRIArray2[n];
                artifactManager.removeRepository(uri);
                ++n;
            }
        }
    }

    public Object[] getCheckedIUElements() {
        if (this.isUpdateToLatest()) {
            Object[] latestUpdates = this.getLatestVersionOfCheckedElements();
            if (this.getUpdatesCanceled) {
                this.checkedElements = null;
                this.checkedElementsUpdates = null;
                throw new OperationCanceledException();
            }
            return latestUpdates;
        }
        return this.viewer.getCheckedElements();
    }

    private Object[] getLatestVersionOfCheckedElements() {
        Object[] checkedArray = this.viewer.getCheckedElements();
        if (this.checkedElements == null) {
            this.checkedElements = new HashSet<Object>(Arrays.asList(checkedArray));
            this.checkedElementsUpdates = new HashSet<Object>(Arrays.asList(this.getUpdates(checkedArray)));
        } else {
            HashSet<Object> checkedElementsNow = new HashSet<Object>(Arrays.asList(checkedArray));
            if (checkedElementsNow.size() != this.checkedElements.size() || !checkedElementsNow.containsAll(this.checkedElements)) {
                this.checkedElements = checkedElementsNow;
                this.checkedElementsUpdates = new HashSet<Object>(Arrays.asList(this.getUpdates(checkedArray)));
            }
        }
        return this.checkedElementsUpdates.toArray();
    }

    public Object[] getSelectedIUElements() {
        return null;
    }

    public void setCheckedElements(Object[] elements) {
        throw new UnsupportedOperationException();
    }

    private Object[] getUpdates(Object[] _checkedElements) {
        ArrayList toInstall = new ArrayList();
        try {
            this.getContainer().run(false, true, monitor -> {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)_checkedElements.length);
                ProvisioningContext context = new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
                Object[] objectArray2 = _checkedElements;
                int n = _checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object iu = objectArray2[n2];
                    if (sub.isCanceled()) {
                        this.getUpdatesCanceled = true;
                        toInstall.clear();
                        sub.done();
                        return;
                    }
                    if (iu instanceof AvailableIUElement) {
                        IInstallableUnit unit = ((AvailableIUElement)iu).getIU();
                        IuUpdateAndPatches updateAndPatches = this.filterToInstall(unit, this.updatesFor(unit, context, (IProgressMonitor)sub.newChild(1)));
                        if (updateAndPatches.update != null) {
                            toInstall.add(updateAndPatches.update);
                        } else {
                            toInstall.add(updateAndPatches.iu);
                            toInstall.addAll(updateAndPatches.patches);
                        }
                    }
                    sub.worked(1);
                    ++n2;
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException((Throwable)e.getCause(), null, (int)3);
        }
        return toInstall.toArray();
    }

    public boolean isUpdateToLatest() {
        return this.updateToLatest.getSelection();
    }

    public ProvisioningContext getProvisioningContext() {
        ProvisioningContext context = new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        context.setArtifactRepositories(this.artiURIs);
        context.setMetadataRepositories(this.metaURIs);
        return context;
    }

    private static boolean hasHigherFidelity(IInstallableUnit iu, IInstallableUnit currentIU) {
        return Boolean.parseBoolean(currentIU.getProperty("org.eclipse.equinox.p2.partial.iu")) && !Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.partial.iu"));
    }

    public Collection<IInstallableUnit> updatesFor(IInstallableUnit toUpdate, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<CallSite, IInstallableUnit> resultsMap = new HashMap<CallSite, IInstallableUnit>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        IQueryable queryable = context.getMetadata((IProgressMonitor)sub.newChild(500));
        for (IInstallableUnit iu : queryable.query((IQuery)new UpdateQuery(toUpdate), (IProgressMonitor)sub.newChild(500))) {
            String key = iu.getId() + "_" + iu.getVersion().toString();
            IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
            if (currentIU != null && !MigrationPage.hasHigherFidelity(iu, currentIU)) continue;
            resultsMap.put((CallSite)((Object)key), iu);
        }
        sub.done();
        return resultsMap.values();
    }

    private IuUpdateAndPatches filterToInstall(IInstallableUnit iu, Collection<IInstallableUnit> updates) {
        IuUpdateAndPatches updateAndPatches = new IuUpdateAndPatches(iu);
        for (IInstallableUnit update : updates) {
            if (QueryUtil.isPatch((IInstallableUnit)update)) {
                updateAndPatches.patches.add(update);
                continue;
            }
            if (updateAndPatches.update != null && updateAndPatches.update.getVersion().compareTo((Object)update.getVersion()) >= 0) continue;
            updateAndPatches.update = update;
        }
        return updateAndPatches;
    }

    public static boolean loadCustomizedSetting() {
        IScopeContext[] contexts = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE, BundleDefaultsScope.INSTANCE, ConfigurationScope.INSTANCE};
        boolean updateToLatest = Platform.getPreferencesService().getBoolean("org.eclipse.equinox.p2.ui.sdk.scheduler", "updateToLatest", false, contexts);
        return updateToLatest;
    }

    final class ImportExportFilteredTree
    extends FilteredTree {
        ArrayList<Object> checkState;

        ImportExportFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
            super(parent, treeStyle, filter, useNewLook);
            this.checkState = new ArrayList();
        }

        protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
            return new CheckboxTreeViewer(composite, style);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            WorkbenchJob job = super.doCreateRefreshJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    Display.getDefault().syncExec(() -> {
                        Object[] checked = ((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.getCheckedElements();
                        if (ImportExportFilteredTree.this.checkState == null) {
                            ImportExportFilteredTree.this.checkState = new ArrayList(checked.length);
                        }
                        Object[] objectArray = checked;
                        int n = checked.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object checked1 = objectArray[n2];
                            if (!((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.getGrayed(checked1) && !ImportExportFilteredTree.this.checkState.contains(checked1)) {
                                ImportExportFilteredTree.this.checkState.add(checked1);
                            }
                            ++n2;
                        }
                    });
                }

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().asyncExec(() -> {
                            if (((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer == null || ((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ImportExportFilteredTree.this.checkState == null) {
                                return;
                            }
                            ((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.setCheckedElements(new Object[0]);
                            ((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.setGrayedElements(new Object[0]);
                            Iterator<Object> iter = ImportExportFilteredTree.this.checkState.iterator();
                            while (iter.hasNext()) {
                                ((ImportExportFilteredTree)ImportExportFilteredTree.this).MigrationPage.this.viewer.setChecked(iter.next(), true);
                            }
                            MigrationPage.this.updatePageCompletion();
                        });
                    }
                }
            });
            return job;
        }
    }

    class ImportFromInstallationLabelProvider
    extends IUDetailsLabelProvider {
        ImportFromInstallationLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = super.getColumnText(element, columnIndex);
            if (columnIndex == 0) {
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
                return MigrationPage.this.getIUNameWithDetail(iu);
            }
            return text;
        }

        public Color getForeground(Object element) {
            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
            if (MigrationPage.this.hasInstalled(iu)) {
                return Display.getDefault().getSystemColor(15);
            }
            return super.getForeground(element);
        }
    }

    class IuUpdateAndPatches {
        public IInstallableUnit iu;
        public IInstallableUnit update;
        public Collection<IInstallableUnit> patches;

        IuUpdateAndPatches(IInstallableUnit iu) {
            this.iu = iu;
            this.patches = new ArrayList<IInstallableUnit>();
        }
    }

    class TreeViewerComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = false;
        private boolean lastAscending = false;

        TreeViewerComparator() {
        }

        public int compare(Viewer viewer1, Object e1, Object e2) {
            IInstallableUnit iu1 = (IInstallableUnit)ProvUI.getAdapter((Object)e1, IInstallableUnit.class);
            IInstallableUnit iu2 = (IInstallableUnit)ProvUI.getAdapter((Object)e2, IInstallableUnit.class);
            if (iu1 != null && iu2 != null) {
                TreeViewer treeViewer;
                IBaseLabelProvider baseLabel;
                if (viewer1 instanceof TreeViewer && (baseLabel = (treeViewer = (TreeViewer)viewer1).getLabelProvider()) instanceof ITableLabelProvider) {
                    ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                    String e1p = tableProvider.getColumnText(e1, this.getSortColumn());
                    String e2p = tableProvider.getColumnText(e2, this.getSortColumn());
                    int result = this.getComparator().compare(e1p, e2p);
                    if (result == 0) {
                        e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        int result2 = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result2 : -1 * result2;
                    }
                    return this.isAscending() ? result : -1 * result;
                }
                return 0;
            }
            return super.compare(viewer1, e1, e2);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            if (this.sortColumn != sortColumn) {
                this.lastSortColumn = this.sortColumn;
                this.lastAscending = this.ascending;
                this.sortColumn = sortColumn;
            }
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

