/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;

public class ResourceBundleHelper {
    public static ResourceBundle getResourceBundle(String resourceURI) throws MalformedURLException, IOException {
        return ResourceBundleHelper.getResourceBundle(resourceURI, Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(String resourceURI, Locale targetLocale) throws MalformedURLException, IOException {
        int index = resourceURI.lastIndexOf("/");
        if (index == -1) {
            throw new IllegalArgumentException("Invalid resourceURI");
        }
        String resourceDirectory = resourceURI.substring(0, index + 1);
        String resourceBundleName = resourceURI.substring(index + 1);
        URL[] classpath = new URL[]{Platform.resolve((URL)new URL(resourceDirectory))};
        URLClassLoader resourceLoader = new URLClassLoader(classpath, null);
        return ResourceBundle.getBundle(resourceBundleName, targetLocale, resourceLoader);
    }
}

