/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KvmEntryHandler
extends VMKernelEventHandler {
    public KvmEntryHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        VirtualMachine host = sp.getCurrentMachine(event);
        if (host == null) {
            return;
        }
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        Object value = ss.queryOngoing(quark);
        int thread = value instanceof Integer ? (Integer)value : -1;
        thread = VirtualCPU.getVirtualCPU(host, cpu.longValue()).getCurrentThread();
        if (thread == -1) {
            return;
        }
        if (host.isHost() && host.isGuest()) {
            VirtualMachine parent;
            VirtualMachine nextLayerVM;
            int quarkVCPUs;
            int quarkVCPU;
            VirtualCPU hostCpu = VirtualCPU.getVirtualCPU(host, cpu.longValue());
            HostThread ht = new HostThread(event.getTrace().getHostId(), Integer.valueOf(thread));
            VirtualCPU nextLayerVCPU = sp.getVirtualCpu(ht);
            hostCpu.setNextLayerVCPU(nextLayerVCPU);
            if (nextLayerVCPU != null && ss.queryOngoingState(quarkVCPU = ss.getQuarkRelativeAndAdd(quarkVCPUs = FusedVMEventHandlerUtils.getMachineCPUsNode(ss, (nextLayerVM = nextLayerVCPU.getVm()).getHostId()), new String[]{nextLayerVCPU.getCpuId().toString()})).isNull()) {
                ss.modifyAttribute(sp.getStartTime(), (Object)thread, quarkVCPU);
            }
            if ((parent = host.getParent()) == null) {
                System.err.println("Parent not found in KvmEntryHandler. This should never happen.");
                return;
            }
            HostThread parentThread = sp.getHostThreadFromVCpu(hostCpu);
            parent.addThreadWaitingForNextLayer(parentThread);
            return;
        }
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Condition"});
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        ss.modifyAttribute(timestamp, (Object)0, quark);
        VirtualCPU hostCpu = VirtualCPU.getVirtualCPU(host, cpu.longValue());
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
        Object status = ss.queryOngoing(quark);
        if (status == null) {
            return;
        }
        hostCpu.setCurrentState((int)((Integer)status));
        HostThread ht = new HostThread(event.getTrace().getHostId(), Integer.valueOf(thread));
        VirtualMachine virtualMachine = sp.getVmFromHostThread(ht);
        if (virtualMachine == null) {
            return;
        }
        VirtualCPU vcpu = sp.getVirtualCpu(ht);
        if (vcpu == null) {
            return;
        }
        if (host.isThreadReadyForNextLayer(ht)) {
            if ((vcpu = vcpu.getNextLayerVCPU()) == null) {
                return;
            }
            virtualMachine = vcpu.getVm();
        } else {
            int quarkVCPUs = FusedVMEventHandlerUtils.getMachineCPUsNode(ss, virtualMachine.getHostId());
            int quarkVCPU = ss.getQuarkRelativeAndAdd(quarkVCPUs, new String[]{vcpu.getCpuId().toString()});
            if (ss.queryOngoingState(quarkVCPU).isNull()) {
                ss.modifyAttribute(timestamp, (Object)thread, quarkVCPU);
            }
        }
        int quarkPCPUs = FusedVMEventHandlerUtils.getMachinepCPUsNode(ss, virtualMachine.getHostId());
        ss.getQuarkRelativeAndAdd(quarkPCPUs, new String[]{cpu.toString()});
        Integer currentVCpu = vcpu.getCpuId().intValue();
        int quarkVCpu = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Virtual_cpu"});
        ss.modifyAttribute(timestamp, (Object)currentVCpu, quarkVCpu);
        int machineNameQuark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Machine_name"});
        ss.modifyAttribute(timestamp, (Object)virtualMachine.getHostId(), machineNameQuark);
        value = vcpu.getCurrentState();
        ss.modifyAttribute(timestamp, value, quark);
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        Object currentThread = ss.queryOngoing(quark);
        if (!(currentThread instanceof Integer)) {
            return;
        }
        hostCpu.setCurrentThread((Integer)currentThread);
        value = vcpu.getCurrentThread();
        ss.modifyAttribute(timestamp, value, quark);
    }
}

