/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans.typed;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousPojoListProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousPojoMapProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousPojoSetProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousPojoValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.PojoListProperty;
import org.eclipse.core.internal.databinding.beans.PojoListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.PojoMapProperty;
import org.eclipse.core.internal.databinding.beans.PojoMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.PojoSetProperty;
import org.eclipse.core.internal.databinding.beans.PojoSetPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.PojoValueProperty;
import org.eclipse.core.internal.databinding.beans.PojoValuePropertyDecorator;

public class PojoProperties {
    public static <S, T> IBeanValueProperty<S, T> value(String propertyName) {
        return PojoProperties.value(null, propertyName, null);
    }

    public static <S, T> IBeanValueProperty<S, T> value(String propertyName, Class<T> valueType) {
        return PojoProperties.value(null, propertyName, valueType);
    }

    public static <S, E> IBeanValueProperty<S, E> value(Class<S> beanClass, String propertyName) {
        return PojoProperties.value(beanClass, propertyName, null);
    }

    public static <S, T> IBeanValueProperty<S, T> value(Class<S> beanClass, String propertyName, Class<T> valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        String[] propertyNames = PojoProperties.split(propertyName);
        if (propertyNames.length > 1) {
            valueType = null;
        }
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new PojoValuePropertyDecorator(new AnonymousPojoValueProperty(propertyNames[0], valueType), null);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyNames[0]);
            property = new PojoValueProperty(propertyDescriptor, valueType);
        }
        IBeanValueProperty beanProperty = new PojoValuePropertyDecorator(property, propertyDescriptor);
        int i = 1;
        while (i < propertyNames.length) {
            beanProperty = beanProperty.value(propertyNames[i]);
            ++i;
        }
        return beanProperty;
    }

    private static String[] split(String propertyName) {
        int index;
        if (propertyName.indexOf(46) == -1) {
            return new String[]{propertyName};
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        while ((index = propertyName.indexOf(46)) != -1) {
            propertyNames.add(propertyName.substring(0, index));
            propertyName = propertyName.substring(index + 1);
        }
        propertyNames.add(propertyName);
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    public static <S, T> IBeanValueProperty<S, T>[] values(Class<S> beanClass, String ... propertyNames) {
        IBeanValueProperty[] properties = new IBeanValueProperty[propertyNames.length];
        int i = 0;
        while (i < properties.length) {
            properties[i] = PojoProperties.value(beanClass, propertyNames[i], null);
            ++i;
        }
        return properties;
    }

    public static <S, T> IBeanValueProperty<S, T>[] values(String ... propertyNames) {
        return PojoProperties.values(null, propertyNames);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName) {
        return PojoProperties.set(null, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName, Class<E> elementType) {
        return PojoProperties.set(null, propertyName, elementType);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<S> beanClass, String propertyName) {
        return PojoProperties.set(beanClass, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousPojoSetProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new PojoSetProperty(propertyDescriptor, elementType);
        }
        return new PojoSetPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName) {
        return PojoProperties.list(null, propertyName, null);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName, Class<E> elementType) {
        return PojoProperties.list(null, propertyName, elementType);
    }

    public static <S, E> IBeanListProperty<S, E> list(Class<S> beanClass, String propertyName) {
        return PojoProperties.list(beanClass, propertyName, null);
    }

    public static <S, E> IBeanListProperty<S, E> list(Class<S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousPojoListProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new PojoListProperty(propertyDescriptor, elementType);
        }
        return new PojoListPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName) {
        return PojoProperties.map(null, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName, Class<K> keyType, Class<V> valueType) {
        return PojoProperties.map(null, propertyName, keyType, valueType);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<S> beanClass, String propertyName) {
        return PojoProperties.map(beanClass, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<S> beanClass, String propertyName, Class<K> keyType, Class<V> valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousPojoMapProperty(propertyName, keyType, valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new PojoMapProperty(propertyDescriptor, keyType, valueType);
        }
        return new PojoMapPropertyDecorator(property, propertyDescriptor);
    }
}

