/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.util.regex.Pattern;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class CodeStyleConfiguration {
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");

    private CodeStyleConfiguration() {
    }

    public static ImportRewrite createImportRewrite(IJavaScriptUnit cu, boolean restoreExistingImports) throws JavaScriptModelException {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((IJavaScriptUnit)cu, (boolean)restoreExistingImports));
    }

    public static ImportRewrite createImportRewrite(JavaScriptUnit astRoot, boolean restoreExistingImports) {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((JavaScriptUnit)astRoot, (boolean)restoreExistingImports));
    }

    private static ImportRewrite configureImportRewrite(ImportRewrite rewrite) {
        IJavaScriptProject project = rewrite.getCompilationUnit().getJavaScriptProject();
        String order = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.importorder", project);
        rewrite.setImportOrder(SEMICOLON_PATTERN.split(order, 0));
        String thres = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", project);
        try {
            int num = Integer.parseInt(thres);
            if (num == 0) {
                num = 1;
            }
            rewrite.setOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        String thresStatic = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.staticondemandthreshold", project);
        try {
            int num = Integer.parseInt(thresStatic);
            if (num == 0) {
                num = 1;
            }
            rewrite.setStaticOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        return rewrite;
    }
}

