/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.HistoryStore;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolBar;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolItemBuilder;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayImages;
import org.eclipse.ui.internal.findandreplace.overlay.SearchHistoryMenu;

public class HistoryTextWrapper
extends Composite {
    private final Text textBar;
    private final AccessibleToolBar tools;
    private final ToolItem dropDown;
    private final HistoryStore history;
    private SearchHistoryMenu menu;

    public HistoryTextWrapper(HistoryStore history, Composite parent, int style) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this);
        this.history = history;
        this.textBar = new Text((Composite)this, style);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 2).applyTo((Control)this.textBar);
        this.tools = new AccessibleToolBar(this);
        this.dropDown = new AccessibleToolItemBuilder(this.tools).withStyleBits(8).withToolTipText(FindReplaceMessages.FindReplaceOverlay_searchHistory_toolTip).withImage(FindReplaceOverlayImages.get("open_history")).withOperation(this::createHistoryMenuDropdown).build();
        this.listenForKeyboardHistoryNavigation();
    }

    private void listenForKeyboardHistoryNavigation() {
        this.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                int stepDirection = e.keyCode == 0x1000001 ? -1 : 1;
                this.navigateInHistory(stepDirection);
            }
        }));
    }

    private void createHistoryMenuDropdown() {
        if (this.menu != null && HistoryTextWrapper.okayToUse((Widget)this.menu.getShell()) || !this.dropDown.isEnabled()) {
            return;
        }
        this.dropDown.setEnabled(false);
        Consumer<String> textUpdaterOnHistoryEntrySelection = selectedHistoryItem -> {
            if (selectedHistoryItem != null) {
                this.textBar.setText(selectedHistoryItem);
            }
        };
        this.menu = new SearchHistoryMenu(this.getShell(), this.history, textUpdaterOnHistoryEntrySelection);
        Point barPosition = this.textBar.toDisplay(0, 0);
        Rectangle dropDownBounds = this.dropDown.getBounds();
        this.menu.setPosition(barPosition.x, barPosition.y + dropDownBounds.height, this.textBar.getSize().x + dropDownBounds.width);
        this.menu.open();
        this.menu.getShell().addDisposeListener(__ -> this.getShell().getDisplay().timerExec(100, this::enableDropDown));
    }

    private void enableDropDown() {
        if (!this.dropDown.isDisposed()) {
            this.dropDown.setEnabled(true);
        }
    }

    private void navigateInHistory(int navigationOffset) {
        if (this.history.size() == 0) {
            return;
        }
        int offset = this.history.indexOf(this.textBar.getText());
        offset += navigationOffset;
        if ((offset %= this.history.size()) < 0) {
            offset = this.history.size() - 1;
        }
        this.textBar.setText(this.history.get(offset));
    }

    public void storeHistory() {
        String string = this.textBar.getText();
        this.history.remove(string);
        this.history.add(string);
    }

    private static boolean okayToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public void selectAll() {
        this.textBar.selectAll();
    }

    public void addModifyListener(ModifyListener listener) {
        this.textBar.addModifyListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.textBar.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.textBar.addKeyListener(listener);
    }

    public void setMessage(String message) {
        this.textBar.setMessage(message);
    }

    public void setSelection(int i, int j) {
        this.textBar.setSelection(i, j);
    }

    public String getSelectionText() {
        return this.textBar.getSelectionText();
    }

    public boolean isFocusControl() {
        return this.textBar.isFocusControl();
    }

    public String getText() {
        return this.textBar.getText();
    }

    public void setText(String str) {
        this.textBar.setText(str);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.textBar.setBackground(color);
        this.tools.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.textBar.setForeground(color);
        this.tools.setForeground(color);
    }

    public boolean forceFocus() {
        if (!this.textBar.isDisposed()) {
            return this.textBar.forceFocus();
        }
        return false;
    }

    public void notifyListeners(int eventType, Event event) {
        this.textBar.notifyListeners(eventType, event);
    }

    public Text getTextBar() {
        return this.textBar;
    }
}

