/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;

public class ParserMessages {
    private static final String BUNDLE_NAME = ParserMessages.class.getName();
    private static ResourceBundle resourceBundle;

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    private ParserMessages() {
    }

    public static String getString(String key) {
        if (resourceBundle == null) {
            return "#" + key + "#";
        }
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, Object[] args) {
        String format = ParserMessages.getString(key);
        return MessageFormat.format(format, args);
    }

    public static String getFormattedString(String key, Object arg) {
        String format = ParserMessages.getString(key);
        if (arg == null) {
            arg = "";
        }
        return MessageFormat.format(format, arg);
    }

    public static String getProblemPattern(ISemanticProblem problem) {
        String key = ParserMessages.getProblemKey(problem.getID());
        if (key != null) {
            return ParserMessages.getString(key);
        }
        return null;
    }

    private static String getProblemKey(int id) {
        switch (id) {
            case 4: {
                return "ISemanticProblem.BINDING_AMBIGUOUS_LOOKUP";
            }
            case 10: {
                return "ISemanticProblem.BINDING_BAD_SCOPE";
            }
            case 6: {
                return "ISemanticProblem.BINDING_CIRCULAR_INHERITANCE";
            }
            case 7: {
                return "ISemanticProblem.BINDING_DEFINITION_NOT_FOUND";
            }
            case 2: {
                return "ISemanticProblem.BINDING_INVALID_OVERLOAD";
            }
            case 12: {
                return "ISemanticProblem.BINDING_INVALID_REDECLARATION";
            }
            case 11: {
                return "ISemanticProblem.BINDING_INVALID_REDEFINITION";
            }
            case 17: {
                return "ISemanticProblem.BINDING_INVALID_STRUCTURED_BINDING_INITIALIZER";
            }
            case 15: {
                return "ISemanticProblem.BINDING_INVALID_TEMPLATE_ARGUMENTS";
            }
            case 5: {
                return "ISemanticProblem.BINDING_INVALID_TYPE";
            }
            case 3: {
                return "ISemanticProblem.BINDING_INVALID_USING";
            }
            case 8: {
                return "ISemanticProblem.BINDING_KNR_PARAMETER_DECLARATION_NOT_FOUND";
            }
            case 9: {
                return "ISemanticProblem.BINDING_LABEL_STATEMENT_NOT_FOUND";
            }
            case 13: {
                return "ISemanticProblem.BINDING_MEMBER_DECLARATION_NOT_FOUND";
            }
            case 16: {
                return "ISemanticProblem.BINDING_NO_CLASS";
            }
            case 1: {
                return "ISemanticProblem.BINDING_NOT_FOUND";
            }
            case 14: {
                return "ISemanticProblem.BINDING_RECURSION_IN_LOOKUP";
            }
            case 10000: {
                return "ISemanticProblem.TYPE_NO_NAME";
            }
            case 10001: {
                return "ISemanticProblem.TYPE_UNRESOLVED_NAME";
            }
            case 10002: {
                return "ISemanticProblem.TYPE_AUTO_FOR_NON_STATIC_FIELD";
            }
            case 10003: {
                return "ISemanticProblem.TYPE_CANNOT_DEDUCE_AUTO_TYPE";
            }
            case 10004: {
                return "ISemanticProblem.TYPE_UNKNOWN_FOR_EXPRESSION";
            }
            case 10005: {
                return "ISemanticProblem.TYPE_NOT_PERSISTED";
            }
            case 10006: {
                return "ISemanticProblem.TYPE_ENUMERATION_EXPECTED";
            }
            case 10007: {
                return "ISemanticProblem.TYPE_CANNOT_DEDUCE_DECLTYPE_AUTO_TYPE";
            }
            case 10008: {
                return "ISemanticProblem.TYPE_AUTO_FOR_VIRTUAL_METHOD";
            }
        }
        return null;
    }
}

