/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.internal.core.model.Template;
import org.eclipse.cdt.internal.core.model.ext.StructureHandle;

public class StructureTemplateHandle
extends StructureHandle
implements IStructureTemplate {
    private Template fTemplate;

    public StructureTemplateHandle(ICElement parent, ICPPClassTemplate classTemplate) throws DOMException {
        super(parent, classTemplate);
        this.fTemplate = new Template(classTemplate.getName());
        ICPPTemplateParameter[] tpars = classTemplate.getTemplateParameters();
        String[] args = new String[tpars.length];
        int i = 0;
        while (i < args.length) {
            args[i] = tpars[i].getName();
            ++i;
        }
        this.fTemplate.setTemplateInfo(null, args);
    }

    public StructureTemplateHandle(ICElement parent, ICPPClassTemplatePartialSpecialization classTemplate) throws DOMException {
        super(parent, classTemplate);
        this.fTemplate = new Template(classTemplate.getName());
        ICPPTemplateArgument[] targs = classTemplate.getTemplateArguments();
        String[] args = new String[targs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = ASTTypeUtil.getArgumentString(targs[i], false);
            ++i;
        }
        this.fTemplate.setTemplateInfo(null, args);
    }

    public StructureTemplateHandle(ICElement parent, ICPPClassSpecialization classBinding, ICPPClassTemplate ct) throws DOMException {
        super(parent, classBinding);
        this.fTemplate = new Template(classBinding.getName());
        ICPPTemplateParameterMap map = classBinding.getTemplateParameterMap();
        ICPPTemplateParameter[] tpars = ct.getTemplateParameters();
        ArrayList<String> args = new ArrayList<String>(tpars.length);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument[] pack;
            ICPPTemplateParameter par = iCPPTemplateParameterArray[n2];
            if (par.isParameterPack() && (pack = map.getPackExpansion(par)) != null) {
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = pack;
                int n3 = pack.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICPPTemplateArgument p = iCPPTemplateArgumentArray[n4];
                    args.add(ASTTypeUtil.getArgumentString(p, false));
                    ++n4;
                }
            } else {
                ICPPTemplateArgument arg = map.getArgument(par);
                args.add(arg == null ? par.getName() : ASTTypeUtil.getArgumentString(arg, false));
            }
            ++n2;
        }
        this.fTemplate.setTemplateInfo(null, args.toArray(new String[args.size()]));
    }

    @Override
    public int getNumberOfTemplateParameters() {
        return this.fTemplate.getNumberOfTemplateParameters();
    }

    @Override
    public String[] getTemplateParameterTypes() {
        return this.fTemplate.getTemplateParameterTypes();
    }

    @Override
    public String[] getTemplateArguments() {
        return this.fTemplate.getTemplateArguments();
    }

    @Override
    public String getTemplateSignature() throws CModelException {
        return this.fTemplate.getTemplateSignature();
    }
}

