/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class PasteTextToScriptShell
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IViewReference viewReference;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITextSelection && (viewReference = PasteTextToScriptShell.findViewReference("org.eclipse.ease.ui.views.scriptShell")) != null) {
            IViewPart view = viewReference.getView(true);
            String selectedText = ((ITextSelection)selection).getText();
            boolean isEmptySelection = selection.isEmpty() || selectedText == null || selectedText.isEmpty();
            String string = selectedText = isEmptySelection ? this.getCurrentLineFromActiveEditor() : selectedText;
            if (!selectedText.isEmpty() && view instanceof IScriptEngineProvider) {
                ((IScriptEngineProvider)view).getScriptEngine().execute((Object)selectedText);
            }
        }
        return null;
    }

    private String getCurrentLineFromActiveEditor() {
        IDocument document;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Control editorControl = (Control)editor.getAdapter(Control.class);
        if (editorControl instanceof StyledText && editor instanceof ITextEditor && (document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null) {
            try {
                IRegion lineInformation = document.getLineInformationOfOffset(((StyledText)editorControl).getCaretOffset());
                return document.get(lineInformation.getOffset(), lineInformation.getLength()).trim();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return "";
    }

    public static IViewReference findViewReference(String idOrTitle) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference viewReference = iViewReferenceArray[n6];
                    if (idOrTitle.equals(viewReference.getId()) || idOrTitle.equals(viewReference.getTitle())) {
                        return viewReference;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

