/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ASTNodeFinder {
    private CompilationUnitDeclaration unit;

    public ASTNodeFinder(CompilationUnitDeclaration unit) {
        this.unit = unit;
    }

    public FieldDeclaration findField(IField fieldHandle) {
        TypeDeclaration typeDecl = this.findType((IType)fieldHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        FieldDeclaration[] fields = typeDecl.fields;
        if (fields != null) {
            char[] fieldName = fieldHandle.getElementName().toCharArray();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                FieldDeclaration field = fields[i];
                if (CharOperation.equals(fieldName, field.name)) {
                    return field;
                }
                ++i;
            }
        }
        return null;
    }

    public Initializer findInitializer(IInitializer initializerHandle) {
        TypeDeclaration typeDecl = this.findType((IType)initializerHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        FieldDeclaration[] fields = typeDecl.fields;
        if (fields != null) {
            int occurenceCount = ((SourceRefElement)((Object)initializerHandle)).occurrenceCount;
            int i = 0;
            int length = fields.length;
            while (i < length) {
                FieldDeclaration field = fields[i];
                if (field instanceof Initializer && --occurenceCount == 0) {
                    return (Initializer)field;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration findMethod(IFunction methodHandle) {
        TypeDeclaration typeDecl = this.findType((IType)methodHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        AbstractMethodDeclaration[] methods = typeDecl.methods;
        if (methods != null) {
            char[] selector = methodHandle.getElementName().toCharArray();
            String[] parameterTypeSignatures = methodHandle.getParameterTypes();
            int parameterCount = parameterTypeSignatures.length;
            int i = 0;
            int length = methods.length;
            while (i < length) {
                block7: {
                    AbstractMethodDeclaration method = methods[i];
                    if (CharOperation.equals(selector, method.getName())) {
                        int argsLength;
                        Argument[] args = method.arguments;
                        int n = argsLength = args == null ? 0 : args.length;
                        if (argsLength == parameterCount) {
                            int j = 0;
                            while (j < parameterCount) {
                                TypeReference type = args[j].type;
                                String signature = Util.typeSignature(type);
                                if (signature.equals(parameterTypeSignatures[j])) {
                                    ++j;
                                    continue;
                                }
                                break block7;
                            }
                            return method;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration findType(IType typeHandle) {
        return null;
    }

    public InferredType findInferredType(IType typeHandle) {
        char[] typeName = typeHandle.getElementName().toCharArray();
        int occurenceCount = ((SourceType)typeHandle).occurrenceCount;
        boolean findAnonymous = typeName.length == 0;
        int count = 0;
        int i = 0;
        while (i < this.unit.numberInferredTypes) {
            InferredType inferredType = this.unit.inferredTypes[i];
            if (inferredType.isDefinition() && (inferredType.isAnonymous ? findAnonymous && ++count == occurenceCount : !findAnonymous && CharOperation.equals(inferredType.getName(), typeName))) {
                return inferredType;
            }
            ++i;
        }
        return null;
    }
}

