/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class MultipleTypeBinding
extends ReferenceBinding {
    public ReferenceBinding[] types;
    int problemID = 0;

    public MultipleTypeBinding(Scope scope, char[][] names) {
        char[][] cfr_ignored_0 = new char[0][];
        ArrayList<TypeBinding> resolveTypes = new ArrayList<TypeBinding>(names.length);
        int i = 0;
        while (i < names.length) {
            TypeBinding typeBinding = scope.getType(names[i]);
            if (typeBinding instanceof ReferenceBinding) {
                if (!typeBinding.isValidBinding()) {
                    this.problemID = typeBinding.problemId();
                } else {
                    this.tagBits |= typeBinding.tagBits;
                    this.modifiers |= ((ReferenceBinding)typeBinding).modifiers;
                    resolveTypes.add(typeBinding);
                    this.compoundName = ((ReferenceBinding)typeBinding).compoundName;
                }
            }
            ++i;
        }
        this.types = resolveTypes.toArray(new ReferenceBinding[resolveTypes.size()]);
    }

    @Override
    public int problemId() {
        return this.problemID;
    }

    @Override
    public FieldBinding[] availableFields() {
        ArrayList<FieldBinding> list = new ArrayList<FieldBinding>();
        int i = 0;
        while (i < this.types.length) {
            FieldBinding[] bindings = this.types[i].availableFields();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new FieldBinding[list.size()]);
    }

    @Override
    public MethodBinding[] availableMethods() {
        ArrayList<MethodBinding> list = new ArrayList<MethodBinding>();
        int i = 0;
        while (i < this.types.length) {
            MethodBinding[] bindings = this.types[i].availableMethods();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new MethodBinding[list.size()]);
    }

    @Override
    public FieldBinding[] fields() {
        ArrayList<FieldBinding> list = new ArrayList<FieldBinding>();
        int i = 0;
        while (i < this.types.length) {
            FieldBinding[] bindings = this.types[i].fields();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new FieldBinding[list.size()]);
    }

    @Override
    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        MethodBinding methodBinding = null;
        int i = 0;
        while (i < this.types.length && methodBinding == null) {
            methodBinding = this.types[i].getExactMethod(selector, argumentTypes, refScope);
            ++i;
        }
        return methodBinding;
    }

    @Override
    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        FieldBinding fieldBinding = null;
        int i = 0;
        while (i < this.types.length && fieldBinding == null) {
            fieldBinding = this.types[i].getField(fieldName, needResolve);
            ++i;
        }
        return fieldBinding;
    }

    @Override
    public InferredType getInferredType() {
        throw new UnimplementedException("should not get here");
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        ArrayList<MethodBinding> list = new ArrayList<MethodBinding>();
        int i = 0;
        while (i < this.types.length) {
            MethodBinding[] bindings = this.types[i].getMethods(selector);
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new MethodBinding[list.size()]);
    }

    @Override
    public boolean hasMemberTypes() {
        throw new UnimplementedException("should not get here");
    }

    @Override
    public boolean isCompatibleWith(TypeBinding otherType) {
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].isCompatibleWith(otherType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isSuperclassOf(ReferenceBinding otherType) {
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].isSuperclassOf(otherType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public MethodBinding[] methods() {
        ArrayList<MethodBinding> list = new ArrayList<MethodBinding>();
        int i = 0;
        while (i < this.types.length) {
            MethodBinding[] bindings = this.types[i].methods();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new MethodBinding[list.size()]);
    }

    @Override
    public char[] signature() {
        char[] sig = new char[]{};
        int i = 0;
        while (i < this.types.length) {
            if (i > 0) {
                sig = CharOperation.append(sig, '|');
            }
            sig = CharOperation.concat(sig, this.types[i].signature());
            ++i;
        }
        return sig;
    }

    @Override
    public boolean isViewedAsDeprecated() {
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].isViewedAsDeprecated()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public char[] readableName() {
        char[] name = new char[]{};
        int i = 0;
        while (i < this.types.length) {
            if (i > 0) {
                name = CharOperation.append(name, '|');
            }
            name = CharOperation.concat(name, this.types[i].readableName());
            ++i;
        }
        return name;
    }

    @Override
    public char[] shortReadableName() {
        char[] name = new char[]{};
        int i = 0;
        while (i < this.types.length) {
            if (i > 0) {
                name = CharOperation.append(name, '|');
            }
            name = CharOperation.concat(name, this.types[i].shortReadableName());
            ++i;
        }
        return name;
    }
}

