/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression
implements IArrayInitializer {
    public Expression[] expressions;
    public ArrayBinding binding;

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int i = 0;
            int max = this.expressions.length;
            while (i < max) {
                flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('[');
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.expressions[i] != null) {
                    this.expressions[i].printExpression(0, output);
                }
                if (--j == 0) {
                    output.append('\n');
                    ArrayInitializer.printIndent(indent + 1, output);
                    j = 20;
                }
                ++i;
            }
        }
        return output.append(']');
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.binding = new ArrayBinding(TypeBinding.UNKNOWN, 1, scope.environment());
        this.resolvedType = this.binding;
        if (this.expressions != null) {
            int i = 0;
            int length = this.expressions.length;
            while (i < length) {
                Expression expression = this.expressions[i];
                expression.resolveType(scope);
                ++i;
            }
        }
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        this.constant = Constant.NotAConstant;
        if (expectedType instanceof ArrayBinding) {
            this.binding = (ArrayBinding)expectedType;
            this.resolvedType = this.binding;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding elementType = this.binding.elementsType();
            int i = 0;
            int length = this.expressions.length;
            while (i < length) {
                TypeBinding exprType;
                Expression expression = this.expressions[i];
                expression.setExpectedType(elementType);
                TypeBinding typeBinding = exprType = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, elementType) : expression.resolveType(scope);
                if (exprType != null) {
                    if (elementType != exprType) {
                        scope.compilationUnitScope().recordTypeConversion(elementType, exprType);
                    }
                    if (!(expression.isConstantValueOfTypeAssignableToType(exprType, elementType) || elementType.isBaseType() && BaseTypeBinding.isWidening(elementType.id, exprType.id) || exprType.isCompatibleWith(elementType) || scope.isBoxingCompatibleWith(exprType, elementType) || exprType.isBaseType() && scope.compilerOptions().sourceLevel >= 0x310000L && !elementType.isBaseType() && expression.isConstantValueOfTypeAssignableToType(exprType, scope.environment().computeBoxingType(elementType)))) {
                        scope.problemReporter().typeMismatchError(exprType, elementType, expression);
                    }
                }
                ++i;
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = TypeBinding.UNKNOWN;
        } else {
            Expression expression = this.expressions[0];
            while (expression != null && expression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)expression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    expression = null;
                    break;
                }
                expression = ((ArrayInitializer)expression).expressions[0];
            }
            if (expression != null) {
                leafElementType = expression.resolveType(scope);
            }
            int i = 1;
            int length = this.expressions.length;
            while (i < length) {
                expression = this.expressions[i];
                if (expression != null) {
                    expression.resolveType(scope);
                }
                ++i;
            }
        }
        if (leafElementType != null) {
            this.resolvedType = scope.createArrayType(leafElementType, dim);
            if (expectedType != null) {
                scope.problemReporter().typeMismatchError(this.resolvedType, expectedType, this);
            }
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i = 0;
            while (i < expressionsLength) {
                if (this.expressions[i] != null) {
                    this.expressions[i].traverse(visitor, scope);
                }
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 9;
    }
}

