/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.advanced;

import java.util.Locale;
import org.eclipse.equinox.bidi.internal.StructuredTextActivator;

public class StructuredTextEnvironment {
    public static final int ORIENT_LTR = 0;
    public static final int ORIENT_RTL = 1;
    public static final int ORIENT_CONTEXTUAL = 2;
    public static final int ORIENT_CONTEXTUAL_LTR = 2;
    public static final int ORIENT_CONTEXTUAL_RTL = 3;
    public static final int ORIENT_UNKNOWN = 4;
    public static final int ORIENT_IGNORE = 8;
    public static final StructuredTextEnvironment DEFAULT = new StructuredTextEnvironment(null, false, 0);
    private final String language;
    private final boolean mirrored;
    private final int orientation;
    private Boolean processingNeeded;

    public StructuredTextEnvironment(String lang, boolean mirrored, int orientation) {
        if (lang != null) {
            this.language = lang.length() > 2 ? lang.substring(0, 2) : lang;
        } else {
            Locale defaultLocale = StructuredTextActivator.getInstance() != null ? StructuredTextActivator.getInstance().getDefaultLocale() : Locale.getDefault();
            this.language = defaultLocale.getLanguage();
        }
        this.mirrored = mirrored;
        this.orientation = orientation >= 0 && orientation <= 8 ? orientation : 4;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean getMirrored() {
        return this.mirrored;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isProcessingNeeded() {
        if (this.processingNeeded == null) {
            boolean supportedOS;
            String osName = StructuredTextActivator.getProperty("os.name");
            if (osName != null) {
                osName = osName.toLowerCase();
            }
            boolean bl = supportedOS = osName.startsWith("windows") || osName.startsWith("linux") || osName.startsWith("mac");
            if (supportedOS) {
                boolean isBidi = "iw".equals(this.language) || "he".equals(this.language) || "ar".equals(this.language) || "fa".equals(this.language) || "ur".equals(this.language);
                this.processingNeeded = isBidi;
            } else {
                this.processingNeeded = Boolean.FALSE;
            }
        }
        return this.processingNeeded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.mirrored ? 1231 : 1237);
        result = 31 * result + this.orientation;
        result = 31 * result + (this.processingNeeded == null ? 0 : this.processingNeeded.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredTextEnvironment other = (StructuredTextEnvironment)obj;
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.mirrored != other.mirrored) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        return !(this.processingNeeded == null ? other.processingNeeded != null : !this.processingNeeded.equals(other.processingNeeded));
    }
}

