/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.events.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

@NonNullByDefault
public class TmfEventTableColumn {
    private static final String EMPTY_STRING = "";
    private final List<ITmfEventAspect<?>> fAspects = new ArrayList();

    public TmfEventTableColumn(ITmfEventAspect<?> aspect) {
        this.fAspects.add(aspect);
    }

    public void addDuplicate(ITmfEventAspect<?> duplicate) {
        this.fAspects.add(duplicate);
    }

    public String getHeaderName() {
        return this.fAspects.get(0).getName();
    }

    public @Nullable String getHeaderTooltip() {
        return this.fAspects.get(0).getHelpText();
    }

    public String getItemString(ITmfEvent event) {
        for (ITmfEventAspect<?> aspect : this.fAspects) {
            String eventString = NonNullUtils.nullToEmptyString((Object)aspect.resolve(event));
            if (eventString.isEmpty()) continue;
            return eventString;
        }
        return EMPTY_STRING;
    }

    public ITmfEventAspect<?> getEventAspect() {
        return this.fAspects.get(0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fAspects.get(0).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventTableColumn)) {
            return false;
        }
        TmfEventTableColumn other = (TmfEventTableColumn)obj;
        return this.fAspects.get(0).equals(other.fAspects.get(0));
    }
}

