/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulableOperation;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class UndoableOperation2ChangeAdapter
implements IUndoableOperation,
IAdvancedUndoableOperation,
ISchedulableOperation {
    private String fLabel;
    private String fDescription;
    private Change fExecuteChange;
    private Change fUndoChange;
    private Change fRedoChange;
    private Change fActiveChange;
    private ChangeDescriptor fChangeDescriptor;
    private List<IUndoContext> fContexts = new ArrayList<IUndoContext>();

    public UndoableOperation2ChangeAdapter(Change change) {
        this.fExecuteChange = change;
        this.fActiveChange = change;
        this.fChangeDescriptor = change.getDescriptor();
    }

    public void setUndoChange(Change undoChange) {
        this.fActiveChange = this.fUndoChange = undoChange;
        this.fExecuteChange = null;
        this.fRedoChange = null;
    }

    public Change getChange() {
        return this.fActiveChange;
    }

    public ChangeDescriptor getChangeDescriptor() {
        return this.fChangeDescriptor;
    }

    public void setChangeDescriptor(ChangeDescriptor descriptor) {
        this.fChangeDescriptor = descriptor;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public String getLabel() {
        if (this.fLabel != null) {
            return this.fLabel;
        }
        return this.fActiveChange.getName();
    }

    public String getDescription() {
        if (this.fDescription != null) {
            return this.fDescription;
        }
        return this.fActiveChange.getName();
    }

    public Object[] getAffectedObjects() {
        if (this.fActiveChange == null) {
            return null;
        }
        return this.fActiveChange.getAffectedObjects();
    }

    public void addContext(IUndoContext context) {
        if (!this.fContexts.contains(context)) {
            this.fContexts.add(context);
        }
    }

    public boolean hasContext(IUndoContext context) {
        if (context == null) {
            return false;
        }
        for (IUndoContext otherContext : this.fContexts) {
            if (!context.matches(otherContext) && !otherContext.matches(context)) continue;
            return true;
        }
        return false;
    }

    public void removeContext(IUndoContext context) {
        this.fContexts.remove(context);
    }

    public IUndoContext[] getContexts() {
        return this.fContexts.toArray(new IUndoContext[this.fContexts.size()]);
    }

    public boolean canExecute() {
        return this.fExecuteChange != null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_execute_label), monitor);
            if (!result.changeExecuted) {
                return this.createStatus(result);
            }
            this.fActiveChange = this.fUndoChange = result.reverseChange;
            this.fExecuteChange = null;
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public boolean canUndo() {
        return this.fUndoChange != null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_undo_label), monitor);
            if (!result.changeExecuted) {
                this.fUndoChange = null;
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.createStatus(result);
            }
            this.fActiveChange = this.fRedoChange = result.reverseChange;
            this.fUndoChange = null;
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) throws ExecutionException {
        if (this.fUndoChange == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_no_undo_available, null);
        }
        try {
            RefactoringStatus status;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((status = this.fUndoChange.isValid(monitor)).hasFatalError()) {
                this.fUndoChange = null;
                this.clearActiveChange();
                return this.asStatus(status);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public boolean canRedo() {
        return this.fRedoChange != null;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_redo_label), monitor);
            if (!result.changeExecuted) {
                this.fUndoChange = null;
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.createStatus(result);
            }
            this.fActiveChange = this.fUndoChange = result.reverseChange;
            this.fRedoChange = null;
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) throws ExecutionException {
        if (this.fRedoChange == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_no_redo_available, null);
        }
        try {
            RefactoringStatus status;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((status = this.fRedoChange.isValid(monitor)).hasFatalError()) {
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.asStatus(status);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public void aboutToNotify(OperationHistoryEvent event) {
    }

    public void dispose() {
        if (this.fActiveChange != null) {
            this.fActiveChange.dispose();
        }
    }

    private ExecuteResult executeChange(IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        ExecuteResult result = new ExecuteResult();
        if (this.fActiveChange == null || !this.fActiveChange.isEnabled()) {
            return result;
        }
        IWorkspaceRunnable runnable = monitor -> {
            boolean reverseIsInitialized = false;
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (int)12);
                executeResult.validationStatus = this.fActiveChange.isValid((IProgressMonitor)subMon.newChild(2));
                if (executeResult.validationStatus.hasFatalError()) {
                    query.stopped(executeResult.validationStatus);
                    return;
                }
                if (!executeResult.validationStatus.isOK() && !query.proceed(executeResult.validationStatus)) {
                    return;
                }
                try {
                    try {
                        executeResult.reverseChange = this.fActiveChange.perform((IProgressMonitor)subMon.newChild(9));
                        executeResult.changeExecuted = true;
                    }
                    finally {
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                    }
                    this.fActiveChange.dispose();
                    if (executeResult.reverseChange != null) {
                        executeResult.reverseChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)subMon.newChild(1)));
                        reverseIsInitialized = true;
                    }
                }
                catch (RuntimeException | CoreException e) {
                    Change ch = executeResult.reverseChange;
                    executeResult.reverseChange = null;
                    if (ch != null && reverseIsInitialized) {
                        ch.dispose();
                    }
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.getSchedulingRule(), 1, pm);
        return result;
    }

    private IStatus createStatus(ExecuteResult result) {
        if (!result.validationStatus.isOK()) {
            return result.validationStatus.getEntryWithHighestSeverity().toStatus();
        }
        return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_error_message, null);
    }

    private IStatus asStatus(RefactoringStatus status) {
        if (status.isOK()) {
            return Status.OK_STATUS;
        }
        return status.getEntryWithHighestSeverity().toStatus();
    }

    private IValidationCheckResultQuery getQuery(IAdaptable info, String title) {
        if (info == null) {
            return RefactoringCore.getQueryFactory().create(null);
        }
        IValidationCheckResultQuery result = (IValidationCheckResultQuery)info.getAdapter(IValidationCheckResultQuery.class);
        if (result != null) {
            return result;
        }
        ContextAdapter context = new ContextAdapter(info, title);
        return RefactoringCore.getQueryFactory().create(context);
    }

    private void clearActiveChange() {
        if (this.fLabel == null) {
            this.fLabel = this.fActiveChange.getName();
        }
        if (this.fDescription == null) {
            this.fDescription = this.fActiveChange.getName();
        }
        this.fActiveChange.dispose();
        this.fActiveChange = null;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static class ContextAdapter
    implements IAdaptable {
        private IAdaptable fInfoAdapter;
        private String fTitle;

        public ContextAdapter(IAdaptable infoAdapter, String title) {
            this.fInfoAdapter = infoAdapter;
            this.fTitle = title;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (String.class.equals(adapter)) {
                return (T)this.fTitle;
            }
            return (T)this.fInfoAdapter.getAdapter(adapter);
        }
    }

    private static class ExecuteResult {
        boolean changeExecuted;
        Change reverseChange;
        RefactoringStatus validationStatus = new RefactoringStatus();
    }
}

