/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.ui.mapping.ResourceMarkAsMergedHandler;
import org.eclipse.team.internal.ui.mapping.ResourceMergeHandler;
import org.eclipse.team.internal.ui.synchronize.actions.RefactorActionGroup;
import org.eclipse.team.ui.mapping.SynchronizationActionProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ResourceModelActionProvider
extends SynchronizationActionProvider {
    private RefactorActionGroup refactorActions;

    @Override
    protected void initialize() {
        ICommonViewerWorkbenchSite cvws;
        IWorkbenchPartSite wps;
        super.initialize();
        ResourceMergeHandler mergeHandler = new ResourceMergeHandler((ISynchronizePageConfiguration)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration"), false);
        this.registerHandler("org.eclipse.team.ui.mergeAction", (IHandler)mergeHandler);
        ResourceMergeHandler overwriteHandler = new ResourceMergeHandler((ISynchronizePageConfiguration)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration"), true);
        this.registerHandler("org.eclipse.team.ui.overwriteAction", (IHandler)overwriteHandler);
        ResourceMarkAsMergedHandler markAsMergedHandler = new ResourceMarkAsMergedHandler((ISynchronizePageConfiguration)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration"));
        this.registerHandler("org.eclipse.team.ui.markAsMergeAction", (IHandler)markAsMergedHandler);
        ICommonViewerSite cvs = this.getActionSite().getViewSite();
        ISynchronizePageConfiguration configuration = this.getSynchronizePageConfiguration();
        if (cvs instanceof ICommonViewerWorkbenchSite && configuration != null && (wps = (cvws = (ICommonViewerWorkbenchSite)cvs).getSite()) instanceof IViewSite) {
            this.refactorActions = new RefactorActionGroup(configuration.getSite(), this.getNavigatorContentService(configuration));
        }
    }

    private INavigatorContentService getNavigatorContentService(ISynchronizePageConfiguration configuration) {
        Viewer v = configuration.getPage().getViewer();
        if (v instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            return cv.getNavigatorContentService();
        }
        return null;
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.refactorActions != null) {
            this.refactorActions.fillActionBars(actionBars);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IContributionItem editGroup = menu.find("edit");
        if (this.refactorActions != null && editGroup != null) {
            this.refactorActions.fillContextMenu(menu, editGroup.getId());
        }
    }

    @Override
    public void updateActionBars() {
        super.updateActionBars();
        if (this.refactorActions != null) {
            this.refactorActions.updateActionBars();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.refactorActions != null) {
            this.refactorActions.dispose();
        }
    }

    @Override
    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.refactorActions != null) {
            this.refactorActions.setContext(context);
        }
    }
}

