/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.ArtifactRepositoryValidator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class CompositeRepositoryApplication
extends AbstractApplication {
    private List<RepositoryDescriptor> childrenToAdd = new ArrayList<RepositoryDescriptor>();
    private List<RepositoryDescriptor> childrenToRemove = new ArrayList<RepositoryDescriptor>();
    private boolean removeAllChildren = false;
    private boolean failOnExists = false;
    private String comparatorID = null;

    public CompositeRepositoryApplication() {
    }

    public CompositeRepositoryApplication(IProvisioningAgent agent) {
        super(agent);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        try {
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            ICompositeRepository metadataRepo = (ICompositeRepository)this.destinationMetadataRepository;
            CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.destinationArtifactRepository;
            if (this.removeAllChildren) {
                if (artifactRepo != null) {
                    artifactRepo.removeAllChildren();
                }
                if (metadataRepo != null) {
                    metadataRepo.removeAllChildren();
                }
            } else {
                for (RepositoryDescriptor child : this.childrenToRemove) {
                    if (child.isArtifact() && artifactRepo != null) {
                        artifactRepo.removeChild(child.getOriginalRepoLocation());
                    }
                    if (!child.isMetadata() || metadataRepo == null) continue;
                    metadataRepo.removeChild(child.getOriginalRepoLocation());
                }
            }
            for (RepositoryDescriptor child : this.childrenToAdd) {
                if (child.isArtifact() && artifactRepo != null) {
                    artifactRepo.addChild(child.getOriginalRepoLocation());
                }
                if (!child.isMetadata() || metadataRepo == null) continue;
                metadataRepo.addChild(child.getOriginalRepoLocation());
            }
            if (this.comparatorID != null) {
                ArtifactRepositoryValidator validator = new ArtifactRepositoryValidator(this.comparatorID);
                IStatus iStatus = validator.validateComposite(artifactRepo);
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.finalizeRepositories();
        }
    }

    public void addChild(RepositoryDescriptor child) {
        this.childrenToAdd.add(child);
    }

    public void removeChild(RepositoryDescriptor child) {
        this.childrenToRemove.add(child);
    }

    public void setRemoveAll(boolean all) {
        this.removeAllChildren = all;
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }

    @Override
    protected <T> IRepository<T> initializeDestination(RepositoryDescriptor toInit, IRepositoryManager<T> mgr) throws ProvisionException {
        String defaultName;
        String repositoryType;
        if (mgr instanceof IArtifactRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
            defaultName = Messages.CompositeRepository_default_artifactRepo_name;
        } else if (mgr instanceof IMetadataRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
            defaultName = Messages.CompositeRepository_default_metadataRepo_name;
        } else {
            throw new AssertionError((Object)("Unsupported repository type: " + String.valueOf(mgr.getClass())));
        }
        mgr.removeRepository(toInit.getRepoLocation());
        try {
            IRepository repository = mgr.loadRepository(toInit.getRepoLocation(), null);
            this.validRepositoryLocation(repository);
            if (!this.initDestinationRepository(repository, toInit)) {
                throw new ProvisionException(Status.info((String)NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)toInit.getRepoLocation())));
            }
            return repository;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
                }
                throw e;
            }
            IRepository source = null;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), 0, null);
                }
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            try {
                String name = Optional.ofNullable(toInit.getName()).orElse(source != null ? source.getName() : defaultName);
                IRepository repo = mgr.createRepository(toInit.getRepoLocation(), name, repositoryType, source != null ? source.getProperties() : null);
                this.initRepository(repo, toInit);
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(toInit.getRepoLocation());
                throw e2;
            }
        }
    }

    private void validRepositoryLocation(IRepository<?> repository) throws ProvisionException {
        if (repository instanceof ICompositeRepository) {
            if (this.failOnExists) {
                throw new ProvisionException(NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)repository.getLocation()));
            }
            RepositoryHelper.validDestinationRepository(repository);
        }
    }

    private void initRepository(IRepository<?> repository, RepositoryDescriptor desc) {
        RepositoryHelper.validDestinationRepository(repository);
        if (desc.isCompressed() && !repository.getProperties().containsKey("p2.compressed")) {
            repository.setProperty("p2.compressed", String.valueOf(true));
        }
        this.setAtomicLoadingProperty(repository, desc);
    }

    private void setAtomicLoadingProperty(IRepository<?> repository, RepositoryDescriptor desc) {
        boolean atomic = true;
        if (desc.getAtomic() != null) {
            atomic = Boolean.valueOf(desc.getAtomic());
        }
        repository.setProperty("p2.atomic.composite.loading", Boolean.toString(atomic));
    }

    public void setComparator(String value) {
        this.comparatorID = value;
    }
}

