/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.CachingIterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class AggregateEventIterator
implements Iterator<ITimeEvent> {
    private final List<CachingIterator> fIterators = new ArrayList<CachingIterator>();
    private final Comparator<ITimeEvent> fComparator;

    public AggregateEventIterator(@NonNull List<ITimeGraphEntry> contributors, Comparator<ITimeEvent> comparator) {
        this(contributors, Long.MIN_VALUE, Long.MAX_VALUE, 1L, comparator);
    }

    public AggregateEventIterator(@NonNull List<ITimeGraphEntry> contributors, long startTime, long endTime, long duration, Comparator<ITimeEvent> comparator) {
        this.fComparator = comparator;
        contributors.forEach(timeGraphEntry -> {
            CachingIterator iterator;
            @NonNull Iterator timeEventsIterator = timeGraphEntry.getTimeEventsIterator(startTime, endTime, duration);
            if (timeEventsIterator != null && (iterator = new CachingIterator(timeEventsIterator, comparator)).hasNext()) {
                this.fIterators.add(iterator);
            }
        });
    }

    @Override
    public boolean hasNext() {
        return !this.fIterators.isEmpty();
    }

    @Override
    public @NonNull ITimeEvent next() {
        List<CachingIterator> iterators = this.fIterators;
        if (iterators.isEmpty()) {
            throw new NoSuchElementException("Aggregate iterator is empty");
        }
        ITimeEvent winner = iterators.get(0).peek();
        long trimTime = winner.getTime() + winner.getDuration();
        int i = 1;
        while (i < iterators.size()) {
            CachingIterator iterator = iterators.get(i);
            ITimeEvent candidate = iterator.peek();
            if (candidate.getTime() < winner.getTime()) {
                trimTime = Math.min(winner.getTime(), candidate.getTime() + candidate.getDuration());
                winner = candidate;
            } else if (candidate.getTime() == winner.getTime()) {
                trimTime = Math.min(trimTime, candidate.getTime() + candidate.getDuration());
                if (this.fComparator.compare(candidate, winner) < 0) {
                    winner = candidate;
                }
            } else {
                trimTime = Math.min(trimTime, candidate.getTime());
            }
            ++i;
        }
        ITimeEvent next = trimTime < winner.getDuration() + winner.getTime() ? winner.splitBefore(trimTime) : winner;
        Iterator<CachingIterator> iteratorIterator = iterators.iterator();
        while (iteratorIterator.hasNext()) {
            CachingIterator iterator = iteratorIterator.next();
            iterator.trim(trimTime);
            if (iterator.hasNext()) continue;
            iteratorIterator.remove();
        }
        return Objects.requireNonNull(next);
    }
}

