/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class StringLiteral
extends Literal {
    protected StringLiteral optionalHead;
    protected Object tail;
    private final int lineNumber;

    public StringLiteral(char[] token, int start, int end, int lineNumber1based) {
        this(null, token, start, end, lineNumber1based - 1);
    }

    protected StringLiteral(StringLiteral optionalHead, Object tail, int start, int end, int lineNumber) {
        super(start, end);
        this.optionalHead = optionalHead;
        this.tail = tail;
        this.lineNumber = lineNumber;
    }

    public StringLiteral(int s, int e) {
        this(null, null, s, e, 0);
    }

    @Override
    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source()));
    }

    public ExtendedStringLiteral extendWith(CharLiteral lit) {
        char[] charTail = new char[]{lit.value};
        return new ExtendedStringLiteral(this, charTail, this.sourceStart, lit.sourceEnd, this.getLineNumber());
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit, this.sourceStart, lit.sourceEnd, this.getLineNumber());
    }

    public StringLiteralConcatenation extendsWith(StringLiteral lit) {
        return new StringLiteralConcatenation(this, lit);
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append('\"');
        char[] cArray = this.source();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char s = cArray[n2];
            Util.appendEscapedChar(output, s, true);
            ++n2;
        }
        output.append('\"');
        return output;
    }

    @Override
    public char[] source() {
        Object object;
        if (this.optionalHead == null && (object = this.tail) instanceof char[]) {
            char[] ch = (char[])object;
            return ch;
        }
        int size = StringLiteral.append(null, 0, this);
        char[] result = new char[size];
        StringLiteral.append(result, 0, this);
        this.flatten(result);
        return result;
    }

    protected void flatten(char[] result) {
        this.setSource(result);
    }

    private static int append(char[] result, int length, StringLiteral o) {
        do {
            if (o.tail instanceof char[]) {
                char[] c = (char[])o.tail;
                if (result != null) {
                    System.arraycopy(c, 0, result, result.length - c.length - length, c.length);
                }
                length += c.length;
                continue;
            }
            length = StringLiteral.append(result, length, (StringLiteral)o.tail);
        } while ((o = o.optionalHead) != null);
        return length;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void setSource(char[] source) {
        this.tail = source;
        this.optionalHead = null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

