/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.util.MissingResourceException;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class CalendarUtil {
    private static ICUCache<String, String> CALTYPE_CACHE = new SimpleCache<String, String>();
    private static final String CALKEY = "calendar";
    private static final String DEFCAL = "gregorian";

    public static String getCalendarType(ULocale loc) {
        String calType = null;
        calType = loc.getKeywordValue(CALKEY);
        if (calType != null) {
            return calType;
        }
        String baseLoc = loc.getBaseName();
        calType = CALTYPE_CACHE.get(baseLoc);
        if (calType != null) {
            return calType;
        }
        ULocale canonical = ULocale.createCanonical(loc.toString());
        calType = canonical.getKeywordValue(CALKEY);
        if (calType == null) {
            String region = canonical.getCountry();
            if (region.length() == 0) {
                ULocale fullLoc = ULocale.addLikelySubtags(canonical);
                region = fullLoc.getCountry();
            }
            try {
                UResourceBundle rb = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt54b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle calPref = rb.get("calendarPreferenceData");
                UResourceBundle order = null;
                try {
                    order = calPref.get(region);
                }
                catch (MissingResourceException mre) {
                    order = calPref.get("001");
                }
                calType = order.getString(0);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (calType == null) {
                calType = DEFCAL;
            }
        }
        CALTYPE_CACHE.put(baseLoc, calType);
        return calType;
    }
}

