/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyString;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.IntegerFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.core.stringlib.MarkupIterator;
import org.python.core.stringlib.TextFormatter;
import org.python.util.PythonInterpreter;

public class StringFormatTest
extends TestCase {
    PythonInterpreter interp = new PythonInterpreter();
    private boolean useBytes = true;

    public void testInternalFormatSpec() {
        InternalFormat.Spec spec = InternalFormat.fromText("x");
        StringFormatTest.assertFalse((boolean)InternalFormat.Spec.specified(spec.align));
        StringFormatTest.assertFalse((boolean)InternalFormat.Spec.specified(spec.fill));
        StringFormatTest.assertFalse((boolean)InternalFormat.Spec.specified(spec.width));
        StringFormatTest.assertFalse((boolean)InternalFormat.Spec.specified(spec.precision));
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = InternalFormat.fromText("<x");
        StringFormatTest.assertEquals((char)'<', (char)spec.align);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = InternalFormat.fromText("~<x");
        StringFormatTest.assertEquals((char)'~', (char)spec.fill);
        StringFormatTest.assertEquals((char)'<', (char)spec.align);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = InternalFormat.fromText("+x");
        StringFormatTest.assertEquals((char)'+', (char)spec.sign);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = InternalFormat.fromText("#x");
        StringFormatTest.assertEquals((boolean)true, (boolean)spec.alternate);
        spec = InternalFormat.fromText("0x");
        StringFormatTest.assertEquals((char)'=', (char)spec.align);
        StringFormatTest.assertEquals((char)'0', (char)spec.fill);
        spec = InternalFormat.fromText("123x");
        StringFormatTest.assertEquals((int)123, (int)spec.width);
        spec = InternalFormat.fromText("123.456x");
        StringFormatTest.assertEquals((int)123, (int)spec.width);
        StringFormatTest.assertEquals((int)456, (int)spec.precision);
        this.assertParseError("123.x", "Format specifier missing precision");
        this.assertParseError("123xx", "Invalid conversion specification");
        spec = InternalFormat.fromText("");
        StringFormatTest.assertEquals((char)'\uffff', (char)spec.type);
    }

    private void assertParseError(String spec, String expected) {
        String error = null;
        try {
            InternalFormat.fromText(spec);
        }
        catch (PyException e) {
            StringFormatTest.assertEquals((Object)Py.ValueError, (Object)e.type);
            error = e.value.toString();
        }
        StringFormatTest.assertEquals((String)expected, error);
    }

    public void testPrepareFormatter() {
        int v = 123;
        IntegerFormatter f = PyInteger.prepareFormatter(InternalFormat.fromText("d"));
        StringFormatTest.assertEquals((String)"123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("o"));
        StringFormatTest.assertEquals((String)"173", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("x"));
        StringFormatTest.assertEquals((String)"7b", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("X"));
        StringFormatTest.assertEquals((String)"7B", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("b"));
        StringFormatTest.assertEquals((String)"1111011", (String)f.format(v).pad().getResult());
        int v2 = 1234567890;
        f = PyInteger.prepareFormatter(InternalFormat.fromText(",d"));
        StringFormatTest.assertEquals((String)"1,234,567,890", (String)f.format(v2).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("#o"));
        StringFormatTest.assertEquals((String)"0o173", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("#X"));
        StringFormatTest.assertEquals((String)"0X7B", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        StringFormatTest.assertEquals((String)"{", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("+d"));
        StringFormatTest.assertEquals((String)"+123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText(" d"));
        StringFormatTest.assertEquals((String)" 123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("5"));
        StringFormatTest.assertEquals((String)"  123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("^6"));
        StringFormatTest.assertEquals((String)" 123  ", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("~<5"));
        StringFormatTest.assertEquals((String)"123~~", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("0=+6"));
        StringFormatTest.assertEquals((String)"+00123", (String)f.format(v).pad().getResult());
        this.assertValueError("0=+6.1", "Precision not allowed in integer format specifier");
        this.assertValueError("+c", "Sign not allowed with integer format specifier 'c'");
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        f.setBytes(true);
        this.assertOverflowError(256, f, "%c arg not in range(0x100)");
        this.assertOverflowError(-1, f, "%c arg not in range(0x100)");
        this.assertOverflowError(0x110000, f, "%c arg not in range(0x100)");
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        this.assertOverflowError(0x110000, f, "%c arg not in range(0x110000)");
        this.assertOverflowError(-1, f, "%c arg not in range(0x110000)");
    }

    public void testPrepareFormatterLong() {
        BigInteger v = BigInteger.valueOf(123L);
        IntegerFormatter f = PyInteger.prepareFormatter(InternalFormat.fromText("d"));
        StringFormatTest.assertEquals((String)"123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("o"));
        StringFormatTest.assertEquals((String)"173", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("x"));
        StringFormatTest.assertEquals((String)"7b", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("X"));
        StringFormatTest.assertEquals((String)"7B", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("b"));
        StringFormatTest.assertEquals((String)"1111011", (String)f.format(v).pad().getResult());
        BigInteger v2 = BigInteger.valueOf(1234567890L);
        f = PyInteger.prepareFormatter(InternalFormat.fromText(",d"));
        StringFormatTest.assertEquals((String)"1,234,567,890", (String)f.format(v2).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("#o"));
        StringFormatTest.assertEquals((String)"0o173", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("#X"));
        StringFormatTest.assertEquals((String)"0X7B", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        StringFormatTest.assertEquals((String)"{", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("+d"));
        StringFormatTest.assertEquals((String)"+123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText(" d"));
        StringFormatTest.assertEquals((String)" 123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("5"));
        StringFormatTest.assertEquals((String)"  123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("^6"));
        StringFormatTest.assertEquals((String)" 123  ", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("~<5"));
        StringFormatTest.assertEquals((String)"123~~", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("0=+6"));
        StringFormatTest.assertEquals((String)"+00123", (String)f.format(v).pad().getResult());
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        f.setBytes(true);
        this.assertOverflowError(BigInteger.valueOf(256L), f, "%c arg not in range(0x100)");
        this.assertOverflowError(BigInteger.valueOf(-1L), f, "%c arg not in range(0x100)");
        this.assertOverflowError(BigInteger.valueOf(0x110000L), f, "%c arg not in range(0x100)");
        f = PyInteger.prepareFormatter(InternalFormat.fromText("c"));
        this.assertOverflowError(BigInteger.valueOf(0x110000L), f, "%c arg not in range(0x110000)");
        this.assertOverflowError(BigInteger.valueOf(-1L), f, "%c arg not in range(0x110000)");
    }

    private void assertValueError(String formatSpec, String expected) {
        try {
            IntegerFormatter f = PyInteger.prepareFormatter(InternalFormat.fromText(formatSpec));
            StringFormatTest.fail((String)("ValueError not thrown, expected: " + expected));
        }
        catch (PyException pye) {
            StringFormatTest.assertEquals((String)expected, (String)pye.value.toString());
        }
    }

    private void assertOverflowError(int v, IntegerFormatter f, String expected) {
        try {
            f.format(v).pad().getResult();
            StringFormatTest.fail((String)("OverflowError not thrown, expected: " + expected));
        }
        catch (PyException pye) {
            StringFormatTest.assertEquals((String)expected, (String)pye.value.toString());
        }
    }

    private void assertOverflowError(BigInteger v, IntegerFormatter f, String expected) {
        try {
            f.format(v).pad().getResult();
            StringFormatTest.fail((String)("OverflowError not thrown, expected: " + expected));
        }
        catch (PyException pye) {
            StringFormatTest.assertEquals((String)expected, (String)pye.value.toString());
        }
    }

    public void testFormatString() {
        String v = "abc";
        TextFormatter f = PyString.prepareFormatter(InternalFormat.fromText(""));
        StringFormatTest.assertEquals((String)"abc", (String)f.format(v).pad().getResult());
        String v2 = "abcdef";
        f = PyString.prepareFormatter(InternalFormat.fromText(".3"));
        StringFormatTest.assertEquals((String)"abc", (String)f.format(v2).pad().getResult());
        f = PyString.prepareFormatter(InternalFormat.fromText("6"));
        StringFormatTest.assertEquals((String)"abc   ", (String)f.format(v).pad().getResult());
    }

    public void implTestMarkupIterator() {
        MarkupIterator iterator = this.newMarkupIterator("abc");
        StringFormatTest.assertEquals((String)"abc", (String)iterator.nextChunk().literalText);
        StringFormatTest.assertNull((Object)iterator.nextChunk());
        iterator = this.newMarkupIterator("First, thou shalt count to {0}");
        MarkupIterator.Chunk chunk = iterator.nextChunk();
        StringFormatTest.assertEquals((String)"First, thou shalt count to ", (String)chunk.literalText);
        StringFormatTest.assertEquals((String)"0", (String)chunk.fieldName);
        StringFormatTest.assertNull((Object)iterator.nextChunk());
        iterator = this.newMarkupIterator("Weight in tons {0.weight!r:s}");
        chunk = iterator.nextChunk();
        StringFormatTest.assertEquals((String)"Weight in tons ", (String)chunk.literalText);
        StringFormatTest.assertEquals((String)"0.weight", (String)chunk.fieldName);
        StringFormatTest.assertEquals((String)"r", (String)chunk.conversion);
        StringFormatTest.assertEquals((String)"s", (String)chunk.formatSpec);
        chunk = this.newMarkupIterator("{{").nextChunk();
        StringFormatTest.assertEquals((String)"{", (String)chunk.literalText);
        chunk = this.newMarkupIterator("}}").nextChunk();
        StringFormatTest.assertEquals((String)"}", (String)chunk.literalText);
        chunk = this.newMarkupIterator("{{}}").nextChunk();
        StringFormatTest.assertEquals((String)"{}", (String)chunk.literalText);
        chunk = this.newMarkupIterator("{0:.{1}}").nextChunk();
        StringFormatTest.assertEquals((String)"0", (String)chunk.fieldName);
        StringFormatTest.assertEquals((String)".{1}", (String)chunk.formatSpec);
        StringFormatTest.assertTrue((boolean)chunk.formatSpecNeedsExpanding);
        this.assertMarkupError("{!}", "end of format while looking for conversion specifier");
        this.assertMarkupError("{!rrrr}", "expected ':' after conversion specifier");
        this.assertMarkupError("{", "Single '{' encountered in format string");
        this.assertMarkupError("}", "Single '}' encountered in format string");
    }

    public void testMarkupIteratorBytes() {
        this.useBytes = true;
        this.implTestMarkupIterator();
    }

    public void testMarkupIteratorUnicode() {
        this.useBytes = false;
        this.implTestMarkupIterator();
    }

    private MarkupIterator newMarkupIterator(String markup) {
        PyString markupObject = this.useBytes ? Py.newString(markup) : Py.newUnicode(markup);
        return new MarkupIterator(markupObject);
    }

    private void assertMarkupError(String markup, String expected) {
        MarkupIterator iterator = this.newMarkupIterator(markup);
        String error = null;
        try {
            iterator.nextChunk();
        }
        catch (IllegalArgumentException e) {
            error = e.getMessage();
        }
        StringFormatTest.assertEquals((String)expected, (String)error);
    }

    public void implTestFieldNameIterator() {
        FieldNameIterator it = this.newFieldNameIterator("abc");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = this.newFieldNameIterator("3");
        StringFormatTest.assertEquals((Object)3, (Object)it.head());
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = this.newFieldNameIterator("abc[0]");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        FieldNameIterator.Chunk chunk = it.nextChunk();
        StringFormatTest.assertEquals((Object)0, (Object)chunk.value);
        StringFormatTest.assertFalse((boolean)chunk.is_attr);
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = this.newFieldNameIterator("abc.def");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        chunk = it.nextChunk();
        StringFormatTest.assertEquals((Object)"def", (Object)chunk.value);
        StringFormatTest.assertTrue((boolean)chunk.is_attr);
        StringFormatTest.assertNull((Object)it.nextChunk());
    }

    public void testFieldNameIteratorBytes() {
        this.useBytes = true;
        this.implTestFieldNameIterator();
    }

    public void testFieldNameIteratorUnicode() {
        this.useBytes = false;
        this.implTestFieldNameIterator();
    }

    private FieldNameIterator newFieldNameIterator(String field) {
        PyString fieldObject = this.useBytes ? Py.newString(field) : Py.newUnicode(field);
        return new FieldNameIterator(fieldObject);
    }
}

