/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.params;

import org.python.bouncycastle.crypto.DerivationParameters;
import org.python.bouncycastle.util.Arrays;

public final class KDFCounterParameters
implements DerivationParameters {
    private final byte[] ki;
    private final byte[] fixedInputData;
    private final int r;

    public KDFCounterParameters(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.ki = Arrays.clone(byArray);
        this.fixedInputData = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        if (n != 8 && n != 16 && n != 24 && n != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.r = n;
    }

    public byte[] getKI() {
        return this.ki;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }

    public int getR() {
        return this.r;
    }
}

