/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.osgi.framework.Bundle;

public final class PluginUtil {
    private PluginUtil() {
    }

    public static Collection<IExtension> findExtensions(String pluginId, String extensionPointId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPointId);
        if (point == null) {
            throw new RuntimeException();
        }
        ArrayList<IExtension> extensions = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            extensions.add(extension);
            ++n2;
        }
        return extensions;
    }

    public static Collection<IConfigurationElement> getTopLevelElements(Collection<IExtension> extensions) {
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        for (IExtension extension : extensions) {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                elements.add(element);
                ++n2;
            }
        }
        return elements;
    }

    public static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        String pluginId = el.getContributor().getName();
        String extPointId = el.getDeclaringExtension().getExtensionPointUniqueIdentifier();
        String msg = Resources.bind(Resources.missingAttribute, pluginId, extPointId, el.getName(), attribute);
        FacetCorePlugin.log(msg);
    }

    public static void reportMissingElement(IConfigurationElement el, String element) {
        String pluginId = el.getContributor().getName();
        String extPointId = el.getDeclaringExtension().getExtensionPointUniqueIdentifier();
        String msg = Resources.bind(Resources.missingElement, pluginId, extPointId, el.getName(), element);
        FacetCorePlugin.log(msg);
    }

    public static String findRequiredAttribute(IConfigurationElement el, String attribute) throws InvalidExtensionException {
        String val = el.getAttribute(attribute);
        if (val == null) {
            PluginUtil.reportMissingAttribute(el, attribute);
            throw new InvalidExtensionException();
        }
        return val;
    }

    public static IConfigurationElement findRequiredElement(IConfigurationElement el, String childElement) throws InvalidExtensionException {
        IConfigurationElement[] children = el.getChildren(childElement);
        if (children.length == 0) {
            PluginUtil.reportMissingElement(el, childElement);
            throw new InvalidExtensionException();
        }
        return children[0];
    }

    public static IConfigurationElement findOptionalElement(IConfigurationElement el, String childElement) {
        IConfigurationElement[] children = el.getChildren(childElement);
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    public static String getElementValue(IConfigurationElement el, String defaultValue) {
        String text;
        if (el != null && (text = el.getValue()) != null && (text = text.trim()).length() > 0) {
            return text;
        }
        return defaultValue;
    }

    public static <T> Class<T> loadClass(String pluginId, String clname) {
        return PluginUtil.loadClass(pluginId, clname, null);
    }

    public static <T> Class<T> loadClass(String pluginId, String clname, Class<T> interfc) {
        Class cl;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            cl = bundle.loadClass(clname);
        }
        catch (Exception e) {
            String msg = Resources.bind((String)Resources.failedToLoadClass, (Object)clname, (Object)pluginId);
            FacetCorePlugin.log(FacetCorePlugin.createErrorStatus(msg, e));
            return null;
        }
        if (interfc != null && !interfc.isAssignableFrom(cl)) {
            String msg = Resources.bind((String)Resources.doesNotImplement, (Object)clname, (Object)interfc.getName());
            FacetCorePlugin.log(FacetCorePlugin.createErrorStatus(msg));
            return null;
        }
        return cl;
    }

    public static <T> T instantiate(String pluginId, Class<T> cl) {
        try {
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToInstantiate, (Object)cl.getName(), (Object)pluginId);
            FacetCorePlugin.log(FacetCorePlugin.createErrorStatus(msg, e));
            return null;
        }
    }

    public static <T> T instantiate(String pluginId, String clname) {
        return PluginUtil.instantiate(pluginId, clname, null);
    }

    public static <T> T instantiate(String pluginId, String clname, Class<T> interfc) {
        Class<T> cl = PluginUtil.loadClass(pluginId, clname, interfc);
        if (cl == null) {
            return null;
        }
        return PluginUtil.instantiate(pluginId, cl);
    }

    public static final class InvalidExtensionException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String missingElement;
        public static String failedToLoadClass;
        public static String failedToInstantiate;
        public static String doesNotImplement;

        static {
            Resources.initializeMessages((String)PluginUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String message, String arg1, String arg2, String arg3, String arg4) {
            return Resources.bind((String)message, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

