/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.ITargetedRuntimesChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.FacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class TargetedRuntimesChangedEvent
extends FacetedProjectEvent
implements ITargetedRuntimesChangedEvent {
    private final Set<IRuntime> oldTargetedRuntimes;
    private final Set<IRuntime> newTargetedRuntimes;

    public TargetedRuntimesChangedEvent(IFacetedProject project, Set<IRuntime> oldTargetedRuntimes, Set<IRuntime> newTargetedRuntimes) {
        super(project, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED);
        this.oldTargetedRuntimes = oldTargetedRuntimes;
        this.newTargetedRuntimes = newTargetedRuntimes;
    }

    @Override
    public Set<IRuntime> getOldTargetedRuntimes() {
        return this.oldTargetedRuntimes;
    }

    @Override
    public Set<IRuntime> getNewTargetedRuntimes() {
        return this.newTargetedRuntimes;
    }

    @Override
    protected void toStringInternal(StringBuilder buf) {
        buf.append("  <old-targeted-runtimes>\n");
        for (IRuntime r : TargetedRuntimesChangedEvent.sort(this.oldTargetedRuntimes)) {
            buf.append("    <runtime name=\"");
            buf.append(r.getName());
            buf.append("\"/>\n");
        }
        buf.append("  </old-targeted-runtimes>\n");
        buf.append("  <new-targeted-runtimes>\n");
        for (IRuntime r : TargetedRuntimesChangedEvent.sort(this.newTargetedRuntimes)) {
            buf.append("    <runtime id=\"");
            buf.append(r.getName());
            buf.append("\"/>\n");
        }
        buf.append("  </new-targeted-runtimes>\n");
    }

    private static Collection<IRuntime> sort(Collection<IRuntime> input) {
        TreeSet<IRuntime> result = new TreeSet<IRuntime>(new RuntimeComparator());
        result.addAll(input);
        return result;
    }

    private static final class RuntimeComparator
    implements Comparator<IRuntime> {
        private RuntimeComparator() {
        }

        @Override
        public int compare(IRuntime r1, IRuntime r2) {
            return r1.getName().compareTo(r2.getName());
        }
    }
}

