/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;

public class HelpBasePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help.base";
    private static HelpBasePlugin plugin;
    private File configurationDirectory;
    private BundleContext context;
    private IHelpActivitySupport helpActivitySupport = new IHelpActivitySupport(){

        @Override
        public boolean isEnabled(String href) {
            return true;
        }

        @Override
        public boolean isRoleEnabled(String href) {
            return true;
        }

        @Override
        public boolean isEnabledTopic(String href, String locale) {
            return true;
        }

        @Override
        public void enableActivities(String href) {
        }

        @Override
        public boolean isFilteringEnabled() {
            return false;
        }

        @Override
        public void setFilteringEnabled(boolean enabled) {
        }

        @Override
        public boolean isUserCanToggleFiltering() {
            return false;
        }

        @Override
        public String getShowAllMessage() {
            return null;
        }

        @Override
        public String getDocumentMessage(boolean embedded) {
            return null;
        }

        @Override
        public boolean getDocumentMessageUsesLiveHelp(boolean embedded) {
            return false;
        }
    };

    public static HelpBasePlugin getDefault() {
        return plugin;
    }

    public void stop(BundleContext context) throws Exception {
        BaseHelpSystem.shutdown();
        this.context = null;
        plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        URL configURL;
        super.start(context);
        plugin = this;
        this.context = context;
        Location location = Platform.getConfigurationLocation();
        if (location != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            this.configurationDirectory = new File(configURL.getFile(), PLUGIN_ID);
        }
        if (this.configurationDirectory == null) {
            this.configurationDirectory = this.getStateLocation().toFile();
        }
        BaseHelpSystem.startup();
    }

    public static File getConfigurationDirectory() {
        return HelpBasePlugin.getDefault().configurationDirectory;
    }

    public static IHelpActivitySupport getActivitySupport() {
        return HelpBasePlugin.getDefault().helpActivitySupport;
    }

    public static void setActivitySupport(IHelpActivitySupport activitySupport) {
        HelpBasePlugin.getDefault().helpActivitySupport = activitySupport;
    }

    public static BundleContext getBundleContext() {
        return HelpBasePlugin.getDefault().context;
    }
}

