/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.lxc;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualMachineModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class LxcModel
implements IVirtualMachineModel {
    private final Map<Long, VirtualMachine> fKnownContainers = new HashMap<Long, VirtualMachine>();
    private static final Map<IKernelAnalysisEventLayout, Set<String>> REQUIRED_EVENTS = new HashMap<IKernelAnalysisEventLayout, Set<String>>();

    @Override
    public @Nullable VirtualMachine getCurrentMachine(ITmfEvent event) {
        return null;
    }

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        ImmutableSet reqEvents = REQUIRED_EVENTS.get(layout);
        if (reqEvents == null) {
            String evProcessState = layout.eventStatedumpProcessState();
            reqEvents = ImmutableSet.of((Object)(evProcessState == null ? "statedump_process_name" : evProcessState), (Object)layout.eventSchedProcessFork());
            REQUIRED_EVENTS.put(layout, (Set<String>)reqEvents);
        }
        return reqEvents;
    }

    @Override
    public @Nullable VirtualCPU getVCpuEnteringHypervisorMode(ITmfEvent event, HostThread ht, IKernelAnalysisEventLayout layout) {
        return null;
    }

    @Override
    public @Nullable VirtualCPU getVCpuExitingHypervisorMode(ITmfEvent event, HostThread ht, IKernelAnalysisEventLayout layout) {
        return null;
    }

    @Override
    public @Nullable VirtualCPU getVirtualCpu(HostThread ht) {
        return null;
    }

    @Override
    public void handleEvent(ITmfEvent event, IKernelAnalysisEventLayout layout) {
    }

    public int numberOfKnownMachines() {
        return this.fKnownContainers.size();
    }

    @Override
    public @Nullable HostThread getVirtualCpuTid(VirtualCPU vcpu) {
        return null;
    }
}

