/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualEnvironmentBuilder;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.handlers.IVirtualMachineModelBuilderEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class QemuKvmEventHandler
implements IVirtualMachineModelBuilderEventHandler {
    private Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private static final ImmutableSet<String> VMSYNC_EVENTS = ImmutableSet.of((Object)"vmsync_gh_guest", (Object)"vmsync_gh_host", (Object)"vmsync_hg_guest", (Object)"vmsync_hg_host");

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.addAll(layout.eventsKVMEntry());
            events.addAll(layout.eventsKVMExit());
            events.addAll((Collection<String>)VMSYNC_EVENTS);
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    @Override
    public void handleBuilderEvent(ITmfStateSystemBuilder ss, ITmfEvent event, VirtualEnvironmentBuilder virtEnv, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        VirtualMachine machine = virtEnv.getCurrentMachineBuild(event);
        long ts = event.getTimestamp().toNanos();
        if (layout.eventsKVMEntry().contains(eventName)) {
            QemuKvmEventHandler.setMachineHost(ss, machine);
            QemuKvmEventHandler.handleKvmEntry(ss, ts, event, virtEnv, machine);
        } else if (layout.eventsKVMExit().contains(eventName)) {
            QemuKvmEventHandler.setMachineHost(ss, machine);
        } else if (eventName.equals("vmsync_gh_guest") || eventName.equals("vmsync_hg_guest")) {
            if (machine.isGuest()) {
                return;
            }
            QemuKvmEventHandler.handleGuestEvent(event, machine);
        } else if (eventName.equals("vmsync_gh_host")) {
            QemuKvmEventHandler.setMachineHost(ss, machine);
            QemuKvmEventHandler.handleHostEvent(ss, ts, event, virtEnv, machine);
        }
    }

    private static void handleHostEvent(ITmfStateSystemBuilder ss, long ts, ITmfEvent event, VirtualEnvironmentBuilder virtEnv, VirtualMachine hostMachine) {
        HostThread ht = IVirtualMachineEventHandler.getCurrentHostThread(event, ts);
        if (ht == null) {
            return;
        }
        VirtualMachine vm = virtEnv.getGuestMachineBuild(event, ht);
        if (vm != null) {
            return;
        }
        Long vmUid = (Long)event.getContent().getFieldValue(Long.class, new String[]{"vm_uid"});
        if (vmUid == null) {
            return;
        }
        for (VirtualMachine machine : virtEnv.getMachines()) {
            if (machine.getVmUid() != vmUid.longValue()) continue;
            hostMachine.addChild(machine);
            int guestQuark = ss.getQuarkAbsoluteAndAdd(new String[]{hostMachine.getHostId(), "Guests", machine.getHostId()});
            ss.modifyAttribute(ts, (Object)machine.getTraceName(), guestQuark);
            virtEnv.setGuestMachine(machine, ht);
            int hypervisorQuark = ss.getQuarkRelativeAndAdd(guestQuark, new String[]{"Hypervisor"});
            ss.modifyAttribute(ts, (Object)"Qemu/KVM", hypervisorQuark);
            Integer pid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
            if (pid == null) {
                return;
            }
            HostThread parentHt = new HostThread(ht.getHost(), pid);
            if (virtEnv.getGuestMachineBuild(event, parentHt) != null) continue;
            virtEnv.setGuestMachine(machine, parentHt);
            int guestProcessQuark = ss.getQuarkRelativeAndAdd(guestQuark, new String[]{"Process Id"});
            ss.modifyAttribute(ts, (Object)pid, guestProcessQuark);
        }
    }

    private static void handleGuestEvent(ITmfEvent event, VirtualMachine machine) {
        Long uid = (Long)event.getContent().getFieldValue(Long.class, new String[]{"vm_uid"});
        if (uid != null) {
            machine.setGuest(uid);
        }
    }

    private static void setMachineHost(ITmfStateSystemBuilder ss, VirtualMachine machine) {
        if (machine.isHost()) {
            return;
        }
        machine.setHost();
        ss.getQuarkAbsoluteAndAdd(new String[]{machine.getHostId(), "Guests"});
    }

    private static void handleKvmEntry(ITmfStateSystemBuilder ss, long ts, ITmfEvent event, VirtualEnvironmentBuilder virtEnv, VirtualMachine machine) {
        HostThread ht = IVirtualMachineEventHandler.getCurrentHostThread(event, ts);
        if (ht == null) {
            return;
        }
        VirtualCPU vcpu = virtEnv.getVirtualCpuBuild(event, ht);
        if (vcpu != null) {
            return;
        }
        VirtualMachine vm = virtEnv.getGuestMachineBuild(event, ht);
        if (vm == null && (vm = QemuKvmEventHandler.findVmFromProcess(event, ht, virtEnv)) == null) {
            return;
        }
        ITmfEventField content = event.getContent();
        Long vcpuId = (Long)content.getFieldValue(Long.class, new String[]{"vcpu_id"});
        if (vcpuId == null) {
            return;
        }
        VirtualCPU virtualCPU = VirtualCPU.getVirtualCPU(vm, vcpuId);
        virtEnv.setGuestCpu(virtualCPU, ht);
        int vcpuQuark = ss.getQuarkAbsoluteAndAdd(new String[]{machine.getHostId(), "Guests", vm.getHostId(), "CPUs", vcpuId.toString()});
        ss.modifyAttribute(ts, (Object)ht.getTid(), vcpuQuark);
    }

    private static @Nullable VirtualMachine findVmFromProcess(ITmfEvent event, HostThread ht, VirtualEnvironmentBuilder virtEnv) {
        Integer pid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        if (pid == null) {
            return null;
        }
        HostThread parentHt = new HostThread(ht.getHost(), pid);
        VirtualMachine vm = virtEnv.getGuestMachineBuild(event, parentHt);
        if (vm != null) {
            virtEnv.setGuestMachine(vm, ht);
        }
        return vm;
    }
}

