/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class VirtualEnvironment
implements IVirtualEnvironmentModel {
    protected final BiMap<HostThread, VirtualCPU> fTidToVcpu = HashBiMap.create();
    protected final Map<HostThread, VirtualMachine> fTidToVm = new HashMap<HostThread, VirtualMachine>();
    protected final Map<String, VirtualMachine> fKnownMachines = new HashMap<String, VirtualMachine>();

    public VirtualEnvironment(ITmfStateSystem stateSystem) {
        this.loadModel(stateSystem);
    }

    private void loadModel(ITmfStateSystem stateSystem) {
        try {
            List fullStates = stateSystem.queryFullState(stateSystem.getCurrentEndTime());
            List quarks = stateSystem.getSubAttributes(-1, false);
            for (Integer machineQuark : quarks) {
                VirtualMachine machine = this.getOrCreateMachine(stateSystem, machineQuark, fullStates);
                int vmQuark = stateSystem.optQuarkRelative(machineQuark.intValue(), new String[]{"Guests"});
                if (vmQuark <= 0) continue;
                machine.setHost();
                List vmQuarks = stateSystem.getSubAttributes(vmQuark, false);
                for (Integer guestQuark : vmQuarks) {
                    this.fillGuestMachine(stateSystem, guestQuark, machine, fullStates);
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private VirtualMachine getOrCreateMachine(ITmfStateSystem stateSystem, int quark, List<ITmfStateInterval> fullStates) {
        String hostId = stateSystem.getAttributeName(quark);
        VirtualMachine machine = this.fKnownMachines.get(hostId);
        if (machine == null) {
            machine = VirtualMachine.newUnknownMachine(hostId, String.valueOf(fullStates.get(quark).getValue()));
            this.fKnownMachines.put(hostId, machine);
        }
        return machine;
    }

    private void fillGuestMachine(ITmfStateSystem stateSystem, int guestQuark, VirtualMachine hostMachine, List<ITmfStateInterval> fullStates) {
        Object pid;
        VirtualMachine guest = this.getOrCreateMachine(stateSystem, guestQuark, fullStates);
        guest.setGuest(1L);
        hostMachine.addChild(guest);
        int processQuark = stateSystem.optQuarkRelative(guestQuark, new String[]{"Process Id"});
        if (processQuark >= 0 && (pid = fullStates.get(processQuark).getValue()) instanceof Integer) {
            this.fTidToVm.put(new HostThread(hostMachine.getHostId(), (Integer)pid), guest);
        }
        for (Integer cpuQuark : stateSystem.getQuarks(guestQuark, new String[]{"CPUs", "*"})) {
            Object tid;
            String cpuStr = stateSystem.getAttributeName(cpuQuark.intValue());
            Long cpu = Longs.tryParse((String)cpuStr);
            if (cpu == null || !((tid = fullStates.get(cpuQuark).getValue()) instanceof Integer)) continue;
            HostThread ht = new HostThread(hostMachine.getHostId(), (Integer)tid);
            this.fTidToVm.put(ht, guest);
            VirtualCPU vcpu = VirtualCPU.getVirtualCPU(guest, cpu);
            this.fTidToVcpu.put((Object)ht, (Object)vcpu);
        }
    }

    protected @Nullable VirtualMachine innerGetCurrentMachine(ITmfEvent event) {
        String hostId = event.getTrace().getHostId();
        return this.fKnownMachines.get(hostId);
    }

    @Override
    public VirtualMachine getCurrentMachine(ITmfEvent event) {
        VirtualMachine machine = this.innerGetCurrentMachine(event);
        if (machine == null) {
            throw new NullPointerException("Machine should not be null");
        }
        return machine;
    }

    @Override
    public @Nullable VirtualCPU getVirtualCpu(ITmfEvent event, HostThread ht) {
        return (VirtualCPU)this.fTidToVcpu.get((Object)ht);
    }

    @Override
    public @Nullable VirtualMachine getGuestMachine(ITmfEvent event, HostThread ht) {
        return this.fTidToVm.get(ht);
    }

    @Override
    public Collection<VirtualMachine> getMachines() {
        return this.fKnownMachines.values();
    }

    @Override
    public @Nullable HostThread getVirtualCpuTid(VirtualCPU vcpu) {
        return (HostThread)this.fTidToVcpu.inverse().get((Object)vcpu);
    }
}

