/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.contentassist.CompoundContentAssistProcessor;

public class StructuredContentAssistant
extends ContentAssistant {
    private List fReleasableProcessors = new ArrayList();
    private boolean fIsInitalized = false;
    private boolean fProcessorsReleased = false;

    public StructuredContentAssistant() {
        this(false);
    }

    public StructuredContentAssistant(boolean asynchronous) {
        super(asynchronous);
    }

    public void setContentAssistProcessor(IContentAssistProcessor processor, String partitionType) {
        this.fIsInitalized = true;
        CompoundContentAssistProcessor compoundProcessor = this.getExistingContentAssistProcessor(partitionType);
        if (compoundProcessor == null) {
            compoundProcessor = new CompoundContentAssistProcessor();
            this.fReleasableProcessors.add(compoundProcessor);
        }
        compoundProcessor.add(processor);
        super.setContentAssistProcessor((IContentAssistProcessor)compoundProcessor, partitionType);
    }

    public boolean isInitialized() {
        return this.fIsInitalized;
    }

    private CompoundContentAssistProcessor getExistingContentAssistProcessor(String partitionType) {
        CompoundContentAssistProcessor compoundContentAssistProcessor = null;
        IContentAssistProcessor processor = super.getContentAssistProcessor(partitionType);
        if (processor != null && processor instanceof CompoundContentAssistProcessor) {
            compoundContentAssistProcessor = (CompoundContentAssistProcessor)processor;
        }
        return compoundContentAssistProcessor;
    }

    public void install(ITextViewer textViewer) {
        if (this.fProcessorsReleased) {
            if (this.fReleasableProcessors != null && !this.fReleasableProcessors.isEmpty()) {
                int i = 0;
                while (i < this.fReleasableProcessors.size()) {
                    ((CompoundContentAssistProcessor)this.fReleasableProcessors.get(i)).install(textViewer);
                    ++i;
                }
            }
            this.fProcessorsReleased = false;
        }
        super.install(textViewer);
    }

    public void uninstall() {
        if (this.fReleasableProcessors != null && !this.fReleasableProcessors.isEmpty()) {
            int i = 0;
            while (i < this.fReleasableProcessors.size()) {
                ((IReleasable)this.fReleasableProcessors.get(i)).release();
                ++i;
            }
        }
        this.fProcessorsReleased = true;
        super.uninstall();
    }
}

