/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger;

import java.util.logging.LogRecord;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

class InnerEvent {
    private final LogRecord fMessage;
    private final double fTs;
    private final String fTid;
    private final String fPid;
    private final String fPhase;

    public static InnerEvent create(LogRecord lRecord) {
        LogUtils.TraceEventLogRecord rec;
        Object[] parameters;
        if (lRecord instanceof LogUtils.TraceEventLogRecord && (parameters = (rec = (LogUtils.TraceEventLogRecord)lRecord).getParameters()) != null && parameters.length >= 3) {
            double ts = (double)((Long)parameters[0]).longValue() * 0.001;
            String phase = String.valueOf(parameters[1]);
            String pid = String.valueOf(parameters[2]);
            String tid = String.valueOf(parameters[2]);
            return new InnerEvent(rec, ts, phase, pid, tid);
        }
        return null;
    }

    public InnerEvent(LogRecord message, double ts, String phase, String pid, String tid) {
        this.fMessage = message;
        this.fTs = ts;
        this.fPhase = phase;
        this.fTid = tid;
        this.fPid = pid;
    }

    public String getMessage() {
        return this.fMessage.getMessage();
    }

    public double getTs() {
        return this.fTs;
    }

    public String getTid() {
        return this.fTid;
    }

    public String getPid() {
        return this.fPid;
    }

    public String getPhase() {
        return this.fPhase;
    }
}

