/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.util.Hashtable;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl.InferredGrammarFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InferredGrammarBuildingCMDocumentLoader
extends CMDocumentLoader {
    protected CMElementDeclaration inferredCMElementDeclaration;
    protected CMDocument inferredCMDocument;
    protected InferredGrammarFactory inferredGrammarFactory;
    protected Hashtable createdCMDocumentTable = new Hashtable();

    public InferredGrammarBuildingCMDocumentLoader(Document document, ModelQuery modelQuery) {
        this(document, modelQuery.getCMDocumentManager());
    }

    public InferredGrammarBuildingCMDocumentLoader(Document document, CMDocumentManager cmDocumentManager) {
        super(document, cmDocumentManager);
        this.inferredGrammarFactory = new InferredGrammarFactory();
    }

    @Override
    public void loadCMDocuments() {
        if (this.inferredGrammarFactory != null) {
            super.loadCMDocuments();
        }
    }

    @Override
    public void handleElement(Element element) {
        CMElementDeclaration parentInferredCMElementDeclaration = this.inferredCMElementDeclaration;
        if (this.inferredCMDocument == null) {
            String cacheKey = "inferred-document";
            this.inferredCMDocument = this.inferredGrammarFactory.createCMDocument("");
            this.cmDocumentManager.addCMDocument("", "", cacheKey, "DTD", this.inferredCMDocument);
            this.createdCMDocumentTable.put(cacheKey, this.inferredCMDocument);
        }
        this.inferredCMElementDeclaration = this.inferredGrammarFactory.createCMElementDeclaration(this.inferredCMDocument, element, false);
        if (parentInferredCMElementDeclaration != null) {
            this.inferredGrammarFactory.createCMContent(this.inferredCMDocument, parentInferredCMElementDeclaration, this.inferredCMDocument, this.inferredCMElementDeclaration, false, null);
        }
        this.visitChildNodes(element);
        this.inferredCMElementDeclaration = parentInferredCMElementDeclaration;
    }

    @Override
    public void handleElementNS(Element element) {
        boolean isLocal;
        String prefix;
        String uri;
        CMDocument parentInferredCMDocument = this.inferredCMDocument;
        CMElementDeclaration parentInferredCMElementDeclaration = this.inferredCMElementDeclaration;
        this.inferredCMDocument = null;
        this.inferredCMElementDeclaration = null;
        if (element.getParentNode() != this.document) {
            this.namespaceTable.addElement(element);
        }
        if ((uri = this.namespaceTable.getURIForPrefix(prefix = element.getPrefix())) == null && element.getParentNode() == this.document) {
            uri = "ommitted-namespace";
            this.namespaceTable.addNamespaceInfo(prefix, uri, "");
        }
        boolean createCMElementDeclaration = true;
        boolean bl = isLocal = uri == null && prefix == null;
        if (isLocal) {
            if (parentInferredCMDocument == null) {
                createCMElementDeclaration = false;
            } else if (uri == null) {
                uri = "ommitted-namespace";
            }
        }
        if (createCMElementDeclaration) {
            if (isLocal) {
                this.inferredCMDocument = parentInferredCMDocument;
                this.inferredCMElementDeclaration = this.inferredGrammarFactory.createCMElementDeclaration(this.inferredCMDocument, element, true);
            } else {
                int status;
                boolean createCMDocument = false;
                String cacheKey = "inferred-document" + uri;
                this.inferredCMDocument = (CMDocument)this.createdCMDocumentTable.get(cacheKey);
                if (this.inferredCMDocument == null && ((status = this.cmDocumentManager.getCMDocumentStatus(uri)) == 0 || status == 4)) {
                    createCMDocument = true;
                }
                if (createCMDocument) {
                    this.inferredCMDocument = this.inferredGrammarFactory.createCMDocument(uri);
                    this.cmDocumentManager.addCMDocument(uri, "", cacheKey, "XSD", this.inferredCMDocument);
                    this.createdCMDocumentTable.put(cacheKey, this.inferredCMDocument);
                }
                if (this.inferredCMDocument != null) {
                    this.inferredCMElementDeclaration = this.inferredGrammarFactory.createCMElementDeclaration(this.inferredCMDocument, element, false);
                }
            }
            if (parentInferredCMElementDeclaration != null) {
                this.inferredGrammarFactory.createCMContent(parentInferredCMDocument, parentInferredCMElementDeclaration, this.inferredCMDocument, this.inferredCMElementDeclaration, isLocal, uri);
            }
        }
        this.visitChildNodes(element);
        this.inferredCMElementDeclaration = parentInferredCMElementDeclaration;
        this.inferredCMDocument = parentInferredCMDocument;
    }
}

