/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.eclipse;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.internal.environment.plugin.EnvironmentPlugin;

public class EclipseLog
implements ILog {
    private org.eclipse.core.runtime.ILog logger;

    public EclipseLog() {
        EnvironmentPlugin plugin = EnvironmentPlugin.getInstance();
        this.logger = plugin.getLog();
    }

    @Override
    public boolean isEnabled() {
        return Platform.inDebugMode();
    }

    @Override
    public boolean isEnabled(String option) {
        return "true".equals(Platform.getDebugOption((String)("org.eclipse.wst.common.environment/trace/" + option)));
    }

    @Override
    public void log(int severity, int messageNum, Object caller, String method, Object object) {
        if (this.isEnabled()) {
            switch (severity) {
                case 4: {
                    if (!this.isEnabled("error")) break;
                    String message = this.getMessageNumString(messageNum) + "E " + String.valueOf(caller) + "::" + method + ": object=" + String.valueOf(object);
                    this.log(severity, message, null);
                    break;
                }
                case 2: {
                    if (!this.isEnabled("warning")) break;
                    String message = this.getMessageNumString(messageNum) + "W " + String.valueOf(caller) + "::" + method + ": object=" + String.valueOf(object);
                    this.log(severity, message, null);
                    break;
                }
                case 1: {
                    if (!this.isEnabled("info")) break;
                    String message = this.getMessageNumString(messageNum) + "I " + String.valueOf(caller) + "::" + method + ": object=" + String.valueOf(object);
                    this.log(severity, message, null);
                }
            }
        }
    }

    @Override
    public void log(int severity, int messageNum, Object caller, String method, IStatus status) {
        this.log(severity, messageNum, caller, method, (Object)status);
    }

    @Override
    public void log(int severity, int messageNum, Object caller, String method, Throwable throwable) {
        this.log(severity, messageNum, caller, method, (Object)null);
    }

    @Override
    public void log(int severity, String option, int messageNum, Object caller, String method, Object object) {
        if (this.isEnabled(option)) {
            String message = this.getMessageNumString(messageNum) + "I " + String.valueOf(caller) + "::" + method + ": object=" + String.valueOf(object);
            this.log(severity, message, null);
        }
    }

    @Override
    public void log(int severity, String option, int messageNum, Object caller, String method, Throwable throwable) {
        if (this.isEnabled(option)) {
            String message = this.getMessageNumString(messageNum) + "I " + String.valueOf(caller) + "::" + method;
            this.log(severity, message, throwable);
        }
    }

    @Override
    public void log(int severity, String option, int messageNum, Object caller, String method, IStatus status) {
        this.logger.log(status);
    }

    private String getMessageNumString(int messageNum) {
        Object messageNumString = "IWAB";
        int innerMessageNum = messageNum;
        if (innerMessageNum > 9999 || innerMessageNum < 0) {
            innerMessageNum = 9999;
        }
        messageNumString = (String)messageNumString + new Integer(innerMessageNum).toString();
        return messageNumString;
    }

    private void log(int severity, String message, Throwable exc) {
        Status status = new Status(severity, "id", 0, message, exc);
        this.logger.log((IStatus)status);
    }
}

