/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiStateCellEditor
extends CellEditor {
    private int fValue;
    private final int fStateCount;

    public MultiStateCellEditor(Composite parent, int stateCount, int initialValue) {
        super(parent);
        Assert.isTrue((stateCount > 1 ? 1 : 0) != 0, (String)"incorrect state count");
        this.fStateCount = stateCount;
        Assert.isTrue((initialValue >= 0 && initialValue < stateCount ? 1 : 0) != 0, (String)"incorrect initial value");
        this.fValue = initialValue;
        this.setValueValid(true);
    }

    public void activate() {
        this.fValue = MultiStateCellEditor.getNextValue(this.fStateCount, this.fValue);
        this.fireApplyEditorValue();
    }

    public static int getNextValue(int stateCount, int currentValue) {
        Assert.isTrue((stateCount > 1 ? 1 : 0) != 0, (String)"incorrect state count");
        Assert.isTrue((currentValue >= 0 && currentValue < stateCount ? 1 : 0) != 0, (String)"incorrect initial value");
        return (currentValue + 1) % stateCount;
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected Object doGetValue() {
        return this.fValue;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof Integer), (String)"value must be Integer");
        this.fValue = (Integer)value;
        Assert.isTrue((this.fValue >= 0 && this.fValue < this.fStateCount ? 1 : 0) != 0, (String)"invalid value");
    }
}

